package fr.inra.agrosyst.web.actions.growingplans;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingPlansList.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingplans/GrowingPlansList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.ArrayList;
import java.util.List;

import com.google.common.collect.Lists;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.growingPlan.GrowingPlanFilter;
import fr.inra.agrosyst.api.services.growingPlan.GrowingPlanService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class GrowingPlansList extends AbstractAgrosystAction {

    private static final long serialVersionUID = -430109839071419528L;

    /** Result serialized in json. */
    protected String growingPlansResult;

    protected GrowingPlanService growingPlanService;

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    @Override
    public String execute() throws Exception {

        NavigationContext navigationContext = getNavigationContext();
        GrowingPlanFilter filter = new GrowingPlanFilter();
        filter.setNavigationContext(navigationContext);
        filter.setPageSize(getConfig().getListResultsPerPage());

        ResultList<GrowingPlan> growingPlanListResult = growingPlanService.getFilteredGrowingPlans(filter);
        growingPlansResult = getGson().toJson(growingPlanListResult);
        return SUCCESS;
    }

    public String getGrowingPlansResult() {
        return growingPlansResult;
    }

    public List<Sector> getSectors() {
        ArrayList<Sector> result = Lists.newArrayList(Sector.values());
        return result;
    }

}
