package fr.inra.agrosyst.web.actions.growingplans;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingPlansEdit.java 600 2013-07-22 08:33:50Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingplans/GrowingPlansEdit.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanImpl;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.growingPlan.GrowingPlanService;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class GrowingPlansEdit extends AbstractAgrosystAction implements Preparable {

    private static final long serialVersionUID = -889011367401120504L;

    protected DomainService domainService;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    protected GrowingPlanService growingPlanService;

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    protected String growingPlanTopiaId;

    protected GrowingPlan growingPlan;

    protected Set<Domain> domains;

    protected String domainId;

    private static final String REQUIRED_FIELD = "Champ obligatoire";

    public void setGrowingPlanTopiaId(String growingPlanTopiaId) {
        this.growingPlanTopiaId = growingPlanTopiaId;
    }

    public GrowingPlan getGrowingPlan() {
        if (growingPlan == null) {
            // EChatellier 27/06/2013 Fais chier de devoir écrire ça, mais c'est la seule option pour ne pas avoir une grosse dose d'exceptions avec du paramsPrepareParams
            return new GrowingPlanImpl();
        }
        return growingPlan;
    }

    @Override
    public void prepare() throws Exception {
        if (StringUtils.isNotBlank(growingPlanTopiaId)) {
            growingPlan = growingPlanService.getGrowingPlan(growingPlanTopiaId);
        } else {
            growingPlan = new GrowingPlanImpl();
        }
    }

    @Override
    public String input() throws Exception {
        // warning, growingPlan's domain must always be part of domains set
        // even not selected be navigation context
        if (getGrowingPlan().getTopiaId() != null) {
            domains = Collections.singleton(getGrowingPlan().getDomain());
        } else {
            DomainFilter domainFilter = new DomainFilter();
            NavigationContext navigationContext = getNavigationContext();
            domainFilter.setNavigationContext(navigationContext);
            domainFilter.setPageSize(DomainFilter.ALL_PAGE_SIZE);
            ResultList<Domain> domainListResult = domainService.getFilteredDomains(domainFilter);
            domains = Sets.newHashSet(domainListResult.getElements());
        }
        return INPUT;
    }

    @Override
    public void validate() {

        // Domaine
        if (StringUtils.isBlank(getGrowingPlan().getTopiaId()) && StringUtils.isBlank(domainId)) {
            addFieldError("domainId", REQUIRED_FIELD);
        }

        // Nom du dispositif
        if (StringUtils.isBlank(growingPlan.getName())) {
            addFieldError("dispositif_name", REQUIRED_FIELD);
        }

        // Type de dispositif
        if (growingPlan.getType() == null) {
            addFieldError("dispositif_type", REQUIRED_FIELD);
        }

        // Filière
        if (growingPlan.getSector() == null) {
            addFieldError("dispositif_sector", REQUIRED_FIELD);
        }

    }

    @Action(results = { @Result(type = "redirectAction", params = {"actionName", "growing-plans-list" }) })
    @Override
    public String execute() throws Exception {
        // can define domain only during create action
        if (StringUtils.isBlank(getGrowingPlan().getTopiaId())) {
            Domain domain = domainService.getDomain(domainId);
            growingPlan.setDomain(domain);
        }
        growingPlanService.updateGrowingPlan(growingPlan);
        return SUCCESS;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public Collection<Domain> getDomains() {
        return domains;
    }

    /**
     * Get all the type that a a domain could be.
     * 
     * @return all the type
     */
    public DomainType[] getTypes() {
        return DomainType.values();
    }

    public List<Sector> getSectors() {
        ArrayList<Sector> result = Lists.newArrayList(Sector.values());
        return result;
    }
}
