package fr.inra.agrosyst.web.actions.generic;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GenericEntitiesListJson.java 630 2013-07-22 15:58:28Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/generic/GenericEntitiesListJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

import com.google.common.collect.Lists;

import fr.inra.agrosyst.api.services.AgrosystFilter;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.api.services.generic.GenericFilter;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class GenericEntitiesListJson extends AbstractJsonAction {

    private static final Log log = LogFactory.getLog(GenericEntitiesListJson.class);

    private static final long serialVersionUID = -4267342874222046159L;

    protected String className;

    protected String filter;

    protected ResultList<?> elements;

    public void setClassName(String className) {
        this.className = className;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    protected GenericEntityService service;

    public void setService(GenericEntityService service) {
        this.service = service;
    }

    private static class RawFilter extends AgrosystFilter {

        private static final long serialVersionUID = 1570045272540504716L;
    }

    @Override
    public String execute() {
        try {
            Class<?> klass = Class.forName(className);

            GenericFilter rawFilter = getGson().fromJson(filter, GenericFilter.class);
            elements = service.listEntities(klass, rawFilter);
        } catch (ClassNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error("Un exception occured", e);
            }
        }

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return elements;
    }
}
