package fr.inra.agrosyst.web.actions.generic;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GenericEntitiesList.java 630 2013-07-22 15:58:28Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/generic/GenericEntitiesList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.lang.reflect.Field;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

import com.google.common.collect.Lists;

import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.api.services.generic.GenericFilter;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class GenericEntitiesList extends AbstractAgrosystAction {

    private static final Log log = LogFactory.getLog(GenericEntitiesList.class);
    private static final long serialVersionUID = -2256628821672426679L;

    protected GenericEntityService service;

    public void setService(GenericEntityService service) {
        this.service = service;
    }

    protected String className;

    protected List<String> properties;

    protected String entitiesJson;

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public String execute() throws Exception {

        try {
            Class<?> klass = Class.forName(className);
            properties = service.getProperties(klass);

            ResultList<?> entities = service.listEntities(klass, null);
            entitiesJson = getGson().toJson(entities);
        } catch (ClassNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error("Un exception occured", e);
            }
        }
        return SUCCESS;
    }

    public String getClassName() {
        return className;
    }

    public String getEntitiesJson() {
        return entitiesJson;
    }

    public List<String> getProperties() {
        return properties;
    }

    public int getPropertiesSize() {
        return properties.size();
    }
}
