/*
 * #%L
 * Agrosyst :: Web
 * $Id: SolDto.java 553 2013-07-17 15:13:47Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/SolDto.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web.actions.domains;

import java.io.Serializable;

/**
 * Sol dto used to edit {@link Sol} in struts (serialized in json).
 * 
 * @author Eric Chatellier
 */
public class SolDto implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5735897928474989471L;

    protected String topiaId;

    protected String name;

    protected String comment;

    protected double importance;

    protected String solArvalisTopiaId;

    protected String sol_nom;

    protected String sol_calcaire;

    protected String sol_hydromorphie;

    protected String sol_pierrosite;

    protected String sol_profondeur;

    protected String sol_texture;

    protected String sol_region;

    protected int sol_region_code;

    protected String solGrenTopiaId;

    public SolDto() {
        
    }

    public SolDto(String topiaId, String name, String comment, double importance) {
        this.topiaId = topiaId;
        this.name = name;
        this.comment = comment;
        this.importance = importance;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getSolArvalisTopiaId() {
        return solArvalisTopiaId;
    }

    public void setSolArvalisTopiaId(String solArvalisTopiaId) {
        this.solArvalisTopiaId = solArvalisTopiaId;
    }

    public String getSol_nom() {
        return sol_nom;
    }

    public void setSol_nom(String sol_nom) {
        this.sol_nom = sol_nom;
    }

    public String getSol_calcaire() {
        return sol_calcaire;
    }

    public void setSol_calcaire(String sol_calcaire) {
        this.sol_calcaire = sol_calcaire;
    }

    public String getSol_hydromorphie() {
        return sol_hydromorphie;
    }

    public void setSol_hydromorphie(String sol_hydromorphie) {
        this.sol_hydromorphie = sol_hydromorphie;
    }

    public String getSol_pierrosite() {
        return sol_pierrosite;
    }

    public void setSol_pierrosite(String sol_pierrosite) {
        this.sol_pierrosite = sol_pierrosite;
    }

    public String getSol_profondeur() {
        return sol_profondeur;
    }

    public void setSol_profondeur(String sol_profondeur) {
        this.sol_profondeur = sol_profondeur;
    }

    public String getSol_texture() {
        return sol_texture;
    }

    public void setSol_texture(String sol_texture) {
        this.sol_texture = sol_texture;
    }

    public String getSol_region() {
        return sol_region;
    }

    public void setSol_region(String sol_region) {
        this.sol_region = sol_region;
    }

    public int getSol_region_code() {
        return sol_region_code;
    }

    public void setSol_region_code(int sol_region_code) {
        this.sol_region_code = sol_region_code;
    }

    public String getSolGrenTopiaId() {
        return solGrenTopiaId;
    }

    public void setSolGrenTopiaId(String solGrenTopiaId) {
        this.solGrenTopiaId = solGrenTopiaId;
    }
}
