/*
 * #%L
 * Agrosyst :: Web
 * $Id: MaterielDto.java 520 2013-07-15 14:22:40Z echatellier $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/MaterielDto.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web.actions.domains;

import java.io.Serializable;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.services.referentiels.MaterielType;

/**
 * MaterielDTO used to edit {@link Materiel} using struts.
 * 
 * @author Eric Chatellier
 */
public class MaterielDto implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5438715230325344950L;

    protected String topiaId;

    protected String name;

    protected String description;

    protected boolean materielETA;

    protected String materielTopiaId;

    protected MaterielType materielType;

    protected String typeMateriel1;

    protected String typeMateriel2;

    protected String typeMateriel3;

    protected String typeMateriel4;

    protected double uniteParAn;

    protected String unite;

    public MaterielDto() {
        
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return Strings.emptyToNull(description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMaterielETA() {
        return materielETA;
    }

    public void setMaterielETA(boolean materielETA) {
        this.materielETA = materielETA;
    }

    public String getMaterielTopiaId() {
        return materielTopiaId;
    }

    public void setMaterielTopiaId(String materielTopiaId) {
        this.materielTopiaId = materielTopiaId;
    }

    public MaterielType getMaterielType() {
        return materielType;
    }

    public void setMaterielType(MaterielType materielType) {
        this.materielType = materielType;
    }

    public String getTypeMateriel1() {
        return typeMateriel1;
    }

    public void setTypeMateriel1(String typeMateriel1) {
        this.typeMateriel1 = typeMateriel1;
    }

    public String getTypeMateriel2() {
        return typeMateriel2;
    }

    public void setTypeMateriel2(String typeMateriel2) {
        this.typeMateriel2 = typeMateriel2;
    }

    public String getTypeMateriel3() {
        return typeMateriel3;
    }

    public void setTypeMateriel3(String typeMateriel3) {
        this.typeMateriel3 = typeMateriel3;
    }

    public String getTypeMateriel4() {
        return typeMateriel4;
    }

    public void setTypeMateriel4(String typeMateriel4) {
        this.typeMateriel4 = typeMateriel4;
    }

    public double getUniteParAn() {
        return uniteParAn;
    }

    public void setUniteParAn(double uniteParAn) {
        this.uniteParAn = uniteParAn;
    }

    public String getUnite() {
        return unite;
    }

    public void setUnite(String unite) {
        this.unite = unite;
    }
}
