package fr.inra.agrosyst.web.actions.domains;

import java.util.List;

import fr.inra.agrosyst.api.services.domain.CommuneValues;
import fr.inra.agrosyst.api.services.domain.CommunesFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ListRefLocationJson.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/ListRefLocationJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */


/**
 * Action de retourner la liste des communes
 *
 * @author David Cossé
 */
public class ListRefLocationJson extends AbstractJsonAction {

    private static final long serialVersionUID = 3930228731417892430L;

    protected DomainService domainService;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    protected List<CommuneValues> communes;

    protected String term;

    @Override
    public String execute() {
        CommunesFilter refCommunesFilter = new CommunesFilter();
        refCommunesFilter.setFilter(term);

        communes = domainService.getRefCommuneValues(refCommunesFilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return communes;
    }

    @Override
    public String input() throws Exception {
        return INPUT;
    }

    public String getTerm() {
        return term;
    }

    public void setTerm(String term) {
        this.term = term;
    }
}
