package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsUnactivate.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsUnactivate.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Désactivation multiple de domaines.
 * 
 * @author Eric Chatellier
 */
public class DomainsUnactivate extends AbstractAgrosystAction {


    private static final long serialVersionUID = 2031204987636332755L;
    
    protected List<String> domainIds;

    public void setDomainIds(List<String> domainIds) {
        this.domainIds = domainIds;
    }

    protected DomainService domainService;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = {
            "actionName", "domains-list" }) })
    public String execute() throws Exception {
        domainService.unactivateDomains(domainIds);
        return SUCCESS;
    }
}
