package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsList.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsList.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Domain list action.
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class DomainsList extends AbstractAgrosystAction {

    /**
     * UID
     */
    private static final long serialVersionUID = 1L;

    /** Domain result serialized as json. */
    protected String domainsResult;

    public String getDomainsResult() {
        return domainsResult;
    }

    protected DomainService domainService;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    public String execute() throws Exception {
        DomainFilter domainFilter = new DomainFilter();
        NavigationContext navigationContext = getNavigationContext();
        domainFilter.setNavigationContext(navigationContext);
        domainFilter.setPageSize(getConfig().getListResultsPerPage());
        ResultList<Domain> domainListResult = domainService.getFilteredDomains(domainFilter);
        domainsResult = getGson().toJson(domainListResult);
        return SUCCESS;
    }
}
