package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsExtend.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsExtend.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Prolongation d'un domaine.
 * 
 * @author Eric Chatellier
 */
public class DomainsExtend extends AbstractAgrosystAction {

    private static final long serialVersionUID = 2031204987636332755L;

    protected DomainService domainService;

    /** Au pluriel car interface communes avec la liste, ne pas modifier. */
    protected String domainIds;

    /** Campagne associée au nouveau domaine. */
    protected int extendCampaign;

    /** Duplicated domain. */
    protected Domain domain;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setDomainIds(String domainIds) {
        this.domainIds = domainIds;
    }

    public void setExtendCampaign(int extendCampaign) {
        this.extendCampaign = extendCampaign;
    }

    @Override
    @Action(results = { @Result(type = "redirectAction", params = {
            "actionName", "domains-edit!input", "domainTopiaId", "${domain.topiaId}"}) })
    public String execute() throws Exception {
        domain = domainService.extendDomain(domainIds, extendCampaign);
        return SUCCESS;
    }

    public Domain getDomain() {
        return domain;
    }
}
