/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsEditJson.java 565 2013-07-18 11:01:06Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsEditJson.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web.actions.domains;

import java.util.ArrayList;
import java.util.List;

import org.apache.struts2.convention.annotation.Action;

import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.services.referentiels.ReferentielService;
import fr.inra.agrosyst.api.services.referentiels.TypeMaterielFilter;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Permet de gerer les methode json pour l'edition d'un domaine.
 * 
 * @author Eric Chatellier
 */
public class DomainsEditJson extends AbstractJsonAction implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4134613183262825235L;

    protected ReferentielService referentielService;

    /** Filter for materiel* actions. */
    protected String filter;

    /** Region for RefSolArvalis actions. */
    protected int regionCode;

    protected Object data;

    public void setReferentielService(ReferentielService referentielService) {
        this.referentielService = referentielService;
    }

    @Override
    public void prepare() throws Exception {
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setRegionCode(int regionCode) {
        this.regionCode = regionCode;
    }

    @Action("domain-edit-materiel-type2-json")
    public String listMaterielType2() throws Exception {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = referentielService.getTypeMateriel2List(typeMaterielFilter);
        return SUCCESS;
    }

    @Action("domain-edit-materiel-type3-json")
    public String listMaterielType3() throws Exception {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = referentielService.getTypeMateriel3List(typeMaterielFilter);
        return SUCCESS;
    }

    @Action("domain-edit-materiel-type4-json")
    public String listMaterielType4() throws Exception {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = referentielService.getTypeMateriel4List(typeMaterielFilter);
        return SUCCESS;
    }
    
    @Action("domain-edit-materiel-unite-json")
    public String listMaterielUnite() throws Exception {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = referentielService.getMaterielUniteMap(typeMaterielFilter);
        return SUCCESS;
    }

    @Action("domain-edit-materiel-all-json")
    public String listMaterielAll() throws Exception {
        TypeMaterielFilter typeMaterielFilter = getGson().fromJson(filter, TypeMaterielFilter.class);
        data = new ArrayList<Object>(4);
        ((List<Object>)data).add(referentielService.getTypeMateriel2List(typeMaterielFilter));
        ((List<Object>)data).add(referentielService.getTypeMateriel3List(typeMaterielFilter));
        ((List<Object>)data).add(referentielService.getTypeMateriel4List(typeMaterielFilter));
        ((List<Object>)data).add(referentielService.getMaterielUniteMap(typeMaterielFilter));
        return SUCCESS;
    }

    @Action("domain-edit-sol-arvalis-list-json")
    public String listSolArvalis() throws Exception {
        data = referentielService.getSolArvalis(regionCode);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return data;
    }
}
