package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ActivityPeriodDto.java 379 2013-07-02 17:16:47Z dcosse $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/ActivityPeriodDto.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.DateUtil;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.ActivityPeriod;

/**
 * DTO de ActivityPeriodDto.
 * 
 * @author David Cossé
 */
public class ActivityPeriodDto implements Comparable<ActivityPeriod>, Serializable {

    private static final long serialVersionUID = 7753711878237490802L;
    
    protected String topiaId;
    
    protected Date startingDate;
    
    protected Date endingDate;
    
    protected String endActivityComment;

    public ActivityPeriodDto() {
    }

    public ActivityPeriodDto(String topiaId, Date startingDate, Date endingDate, String endActivityComment) {
        this.topiaId = topiaId;
        this.startingDate = startingDate;
        this.endingDate = endingDate;
        this.endActivityComment = endActivityComment;
    }

    @Override
    public int compareTo(ActivityPeriod activityPeriod) {
        int result = 0;
        if (activityPeriod.getStartingDate().equals(startingDate)
                && activityPeriod.getEndingDate().equals(endingDate)
                && StringUtils.equalsIgnoreCase(
                        StringUtils.trim(
                                activityPeriod.getEndActivityComment()),
                        StringUtils.trim(
                                endActivityComment))
            ) {
            result = 0;
        } else {
            result = -1;
        }
        return result;
    }

    
    public boolean isEmpty() {
        boolean result =
                startingDate == null
                && endingDate == null
                && Strings.isNullOrEmpty(endActivityComment);
        return result;
    }
    
    /**
     * The date is valid if 
     *  - startingDate is not null
     *  and in case of it exist an endingDate
     *  - the endingDate is after the startingDate
     *    and before the end of the actual day.
     *  
     * @return true if the date is valid
     */
    public boolean isValid() {
        Date today = new Date();
        DateUtil.setMaxTimeOfDay(today);
        boolean result = startingDate != null
                && (( endingDate != null && (endingDate.after(startingDate) || endingDate.equals(startingDate)) && endingDate.before(today))
                || ( endingDate == null ));
        return result;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public Date getStartingDate() {
        return startingDate;
    }

    public String getStartingDateFormatted() {
        return new SimpleDateFormat("dd/MM/yyyy").format(startingDate); // TODO AThimel 27/06/13 Better way ?
    }

    public void setStartingDate(Date startingDate) {
        this.startingDate = startingDate;
    }

    public Date getEndingDate() {
        return endingDate;
    }

    public String getEndingDateFormatted() {
        return new SimpleDateFormat("dd/MM/yyyy").format(endingDate); // TODO AThimel 27/06/13 Better way ?
    }

    public void setEndingDate(Date endingDate) {
        this.endingDate = endingDate;
    }

    public String getEndActivityComment() {
        return endActivityComment;
    }

    public void setEndActivityComment(String endActivityComment) {
        this.endActivityComment = endActivityComment;
    }

    
}
