package fr.inra.agrosyst.web.actions.context;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ContextChooseRaw.java 617 2013-07-22 13:51:38Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/context/ContextChooseRaw.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.context.NavigationContextService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class ContextChooseRaw extends AbstractJsonAction implements Preparable {

    private static final long serialVersionUID = 8311330060409844511L;

    /**
     * Return true for each value. (Used for javascript selection standard).
     */
    public static final Function<String, Boolean> GET_TRUE = new Function<String, Boolean>() {
        @Override
        public Boolean apply(String input) {
            return Boolean.TRUE;
        }
    };

    public static final Function<Object,String> TO_STRING = new Function<Object, String>() {
        @Override
        public String apply(Object input) {
            return String.valueOf(input);
        }
    };

    protected Map<Integer, Long> campaignsList;
    protected ResultList<Domain> domains;
    protected ResultList<GrowingPlan> growingPlans;
    protected ResultList<GrowingSystem> growingSystems;
    protected NavigationContext navigationContext;

    protected Set<Integer> selectedCampaigns;
    protected Set<String> selectedDomains;
    protected Set<String> selectedGrowingPlans;
    protected Set<String> selectedGrowingSystems;

    @Override
    public void prepare() throws Exception {
    }

    public void setSelectedCampaigns(Set<Integer> selectedCampaigns) {
        this.selectedCampaigns = selectedCampaigns;
    }

    public void setSelectedDomains(Set<String> selectedDomains) {
        this.selectedDomains = selectedDomains;
    }

    public void setSelectedGrowingPlans(Set<String> selectedGrowingPlans) {
        this.selectedGrowingPlans = selectedGrowingPlans;
    }

    public void setSelectedGrowingSystems(Set<String> selectedGrowingSystems) {
        this.selectedGrowingSystems = selectedGrowingSystems;
    }

    @Override
    public String input() throws Exception {
        navigationContext = super.getNavigationContext();

        Set<Integer> campaignForFiltering = navigationContext.getCampaigns();
        Set<String> domainsForFiltering = navigationContext.getDomains();
        Set<String> growingPlansForFiltering = navigationContext.getGrowingPlans();

        campaignsList = navigationContextService.getAllCampaigns();
        domains = navigationContextService.getAllDomainsForCampaign(campaignForFiltering);
        growingPlans = navigationContextService.getAllGrowingPlansForDomains(campaignForFiltering, domainsForFiltering);
        growingSystems = navigationContextService.getAllGrowingSystemsForGrowingPlans(campaignForFiltering, domainsForFiltering, growingPlansForFiltering);
        return INPUT;
    }

    @Override
    public String execute() throws Exception {

        NavigationContext newNavigationContext = new NavigationContext();
        newNavigationContext.getCampaigns().addAll(selectedCampaigns);

        if (selectedDomains != null) {
            newNavigationContext.getDomains().addAll(selectedDomains);
        }

        if (selectedGrowingPlans != null) {
            newNavigationContext.getGrowingPlans().addAll(selectedGrowingPlans);
        }

        if (selectedGrowingSystems != null) {
            newNavigationContext.getGrowingSystems().addAll(selectedGrowingSystems);
        }

        verifyAndSaveNavigationContext(newNavigationContext);

        return SUCCESS;
    }

    public Map<Integer, Long> getCampaignsList() {
        return campaignsList;
    }

    public String getSelectedCampaignsJson() {
        Set<Integer> campaigns = navigationContext.getCampaigns();
        String result = "{}";
        if (!campaigns.isEmpty()) {
            Iterable<String> strings = Iterables.transform(campaigns, TO_STRING);
            result = getGson().toJson(Lists.newArrayList(strings));
        }
        return result;
    }

    public String getDomainsJson() {
        String result = getGson().toJson(domains);
        return result;
    }

    public String getSelectedDomainsJson() {
        Set<String> domains = navigationContext.getDomains();
        String result = "{}";
        if (!domains.isEmpty()) {
            Map<String, Boolean> domainsIds = Maps.toMap(domains, GET_TRUE);
            result = getGson().toJson(domainsIds);
        }
        return result;
    }

    public String getGrowingPlansJson() {
        String result = getGson().toJson(growingPlans);
        return result;
    }

    public String getSelectedGrowingPlansJson() {
        Set<String> dispositifs = navigationContext.getGrowingPlans();
        String result = "{}";
        if (!dispositifs.isEmpty()) {
            Map<String, Boolean> growingPlansIds = Maps.toMap(dispositifs, GET_TRUE);
            result = getGson().toJson(growingPlansIds);
        }
        return result;
    }

    public String getGrowingSystemsJson() {
        String result = getGson().toJson(growingSystems);
        return result;
    }

    public String getSelectedGrowingSystemsJson() {
        Set<String> sdcs = navigationContext.getGrowingSystems();
        String result = "{}";
        if (!sdcs.isEmpty()) {
            Map<String, Boolean> growingSystemsIds = Maps.toMap(sdcs, GET_TRUE);
            result = getGson().toJson(growingSystemsIds);
        }
        return result;
    }

    public NavigationContext getNavigationContext() {
        return navigationContext;
    }

    public List<Sector> getSectors() {
        ArrayList<Sector> result = Lists.newArrayList(Sector.values());
        return result;
    }

    @Override
    public Object getJsonData() {
        return new Object();
    }

}
