package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: RunImport.java 672 2013-07-23 14:35:25Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/RunImport.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.referentiels.RefLocation;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referentiels.RefSolArvalis;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.referentiels.ImportResult;
import fr.inra.agrosyst.api.services.referentiels.ImportService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class RunImport extends AbstractAgrosystAction {

    private static final long serialVersionUID = 4130324772446717782L;

    protected ImportService importService;

    public void setImportService(ImportService importService) {
        this.importService = importService;
    }

    protected String className;
    protected Class<?> klass;

    protected File source1;
    protected File source2;
    protected File source3;

    public void setClassName(String className) {
        this.className = className;
    }

    public void setSource1(File source1) {
        this.source1 = source1;
    }

    public void setSource2(File source2) {
        this.source2 = source2;
    }

    public void setSource3(File source3) {
        this.source3 = source3;
    }

    protected void required(File ... sources) {
        if (sources != null) {
            int index = 0;
            for (File source : sources) {
                index++;
                if (source == null) {
                    addFieldError("source" + index, "Fichier manquant");
                }
            }
        }
    }

    @Override
    public void validate() {
        if (Strings.isNullOrEmpty(className)) {
            addFieldError("className", "Ce champ est obligatoire");
        }

        try {
            klass = Class.forName(className);
        } catch (ClassNotFoundException e) {
            addFieldError("className", "Classe non trouvée");
        }

        if (RefSolArvalis.class.equals(klass)) {
            required(source1, source2);
        }

        if (RefLocation.class.equals(klass)) {
            required(source1, source2, source3);
        }

        if (RefMaterielTraction.class.equals(klass)) {
            required(source1);
        }

        if (RefMaterielIrrigation.class.equals(klass)) {
            required(source1);
        }

        if (RefMaterielAutomoteur.class.equals(klass)) {
            required(source1);
        }

        if (RefMaterielOutil.class.equals(klass)) {
            required(source1);
        }

        super.validate();
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {
            "namespace", "/admin", "actionName", "home"})})
    public String execute() throws Exception {

        ImportResult importResult = null;

        if (RefSolArvalis.class.equals(klass)) {
            importResult = importService.importSolArvalisCSV(
                    new FileInputStream(source1),
                    new FileInputStream(source2));
        }

        if (RefLocation.class.equals(klass)) {
            importResult = importService.importCommuneInseeCSV(
                    new FileInputStream(source1),
                    new FileInputStream(source2),
                    new FileInputStream(source3));
        }

        if (RefMaterielTraction.class.equals(klass)) {
            importResult = importService.importMaterielTracteursCSV(
                    new FileInputStream(source1));
        }

        if (RefMaterielIrrigation.class.equals(klass)) {
            importResult = importService.importMaterielIrrigationCSV(
                    new FileInputStream(source1));
        }

        if (RefMaterielAutomoteur.class.equals(klass)) {
            importResult = importService.importMaterielAutomoteursCSV(
                    new FileInputStream(source1));
        }

        if (RefMaterielOutil.class.equals(klass)) {
            importResult = importService.importMaterielOutilsCSV(
                    new FileInputStream(source1));
        }

        if (importResult != null) {
            String message = String.format(
                    "Import terminé en %dms. %d créé(s) - %d modifié(s) - %d supprimé(s) - %d ignoré(s)",
                    importResult.getDuration(),
                    importResult.getCreated(),
                    importResult.getUpdated(),
                    importResult.getDeleted(),
                    importResult.getIgnored()
            );
            session.addMessage(message);
        }
        return SUCCESS;
    }

}
