package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: Home.java 672 2013-07-23 14:35:25Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/Home.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.PracticedSystemSource;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.Zoning;
import fr.inra.agrosyst.api.entities.referentiels.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referentiels.RefLocation;
import fr.inra.agrosyst.api.entities.referentiels.RefMateriel;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referentiels.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referentiels.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referentiels.RefSolGren;
import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class Home extends AbstractAgrosystAction {

    private static final long serialVersionUID = 6516792714690014172L;

    protected Map<String, Long> referentialClasses;

    protected Map<String, Long> autorityClasses;

    protected GenericEntityService service;

    public void setService(GenericEntityService service) {
        this.service = service;
    }

    @Override
    public String execute() throws Exception {

        referentialClasses = service.countEntities(
                RefLocation.class,
                RefSolArvalis.class,
                RefSolGren.class,
                RefLegalStatus.class,
                RefMateriel.class,
                RefMaterielAutomoteur.class,
                RefMaterielIrrigation.class,
                RefMaterielTraction.class,
                RefMaterielOutil.class
        );

        autorityClasses = service.countEntities(
                DomainType.class,
                Sector.class,
                PracticedSystemSource.class,
                WaterFlowDistance.class,
                Zoning.class,
                MaxSlope.class
        );

        return SUCCESS;
    }

    public Map<String, Long> getReferentialClasses() {
        return referentialClasses;
    }

    public Map<String, Long> getAutorityClasses() {
        return autorityClasses;
    }
}
