package fr.inra.agrosyst.web.actions;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: RichNavigationContext.java 617 2013-07-22 13:51:38Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/RichNavigationContext.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.services.context.NavigationContextService;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class RichNavigationContext {

    protected static final Function<Integer, String> GET_CAMPAIGN_NAME = new Function<Integer, String>() {
        @Override
        public String apply(Integer campaign) {
            String result = String.format("%d (%d - %d)", campaign, campaign - 1, campaign);
            return result;
        }
    };

    protected NavigationContext navigationContext;

    protected NavigationContextService navigationContextService;

    public RichNavigationContext(NavigationContext navigationContext, NavigationContextService navigationContextService) {
        this.navigationContext = navigationContext;
        this.navigationContextService = navigationContextService;
    }

    public Set<Integer> getCampaigns() {
        Set<Integer> result = navigationContext.getCampaigns();
        return result;
    }

    protected <K> String getFirstNames(Set<K> ids, Function<K, String> getNameFunction) {
        String result = null;
        if (ids != null && !ids.isEmpty()) {
            List<String> names = Lists.newArrayList();
            Iterator<K> iterator = ids.iterator();
            while (iterator.hasNext() && names.size() < 2) {
                K id = iterator.next();
                String name = getNameFunction.apply(id);
                if (name == null) {
                    iterator.remove();
                } else {
                    names.add(name);
                }
            }
            Collections.sort(names);
            result = Joiner.on(", ").join(names);
        }
        return result;
    }

    public String getCampaignNames() {
        String result = getFirstNames(navigationContext.getCampaigns(), GET_CAMPAIGN_NAME);
        return result;
    }

    public String getFirstDomainNames() {
        Function<String, String> getDomainNameFunction = new Function<String, String>() {
            @Override
            public String apply(String input) {
                Domain domain = navigationContextService.getDomain(input);
                String result = null;
                if (domain != null) {
                    result = domain.getName();
                }
                return result;
            }
        };
        String result = getFirstNames(navigationContext.getDomains(), getDomainNameFunction);
        return result;
    }

    public String getFirstGrowingPlanNames() {
        Function<String, String> getGrowingPlanNameFunction = new Function<String, String>() {
            @Override
            public String apply(String input) {
                GrowingPlan dispositif = navigationContextService.getGrowingPlan(input);
                String result = null;
                if (dispositif != null) {
                    result = dispositif.getName();
                }
                return result;
            }
        };
        String result = getFirstNames(navigationContext.getGrowingPlans(), getGrowingPlanNameFunction);
        return result;
    }

    public String getFirstGrowingSystemNames() {

        Function<String, String> getGrowingSystemNameFunction = new Function<String, String>() {
            @Override
            public String apply(String input) {
                GrowingSystem sdc = navigationContextService.getGrowingSystem(input);
                String result = null;
                if (sdc != null) {
                    result = sdc.getName();
                }
                return result;
            }
        };
        String result = getFirstNames(navigationContext.getGrowingSystems(), getGrowingSystemNameFunction);
        return result;
    }

    public int getDomainsCount() {
        return navigationContext.getDomainsCount();
    }

    public int getGrowingPlansCount() {
        return navigationContext.getGrowingPlansCount();
    }

    public int getGrowingSystemsCount() {
        return navigationContext.getGrowingSystemsCount();
    }

}
