package fr.inra.agrosyst.web.actions;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AbstractJsonAction.java 265 2013-06-25 09:28:40Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/AbstractJsonAction.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

/**
 * Abstract action used to render custom objects as json string using gson directly in response output stream.
 *
 * @author Eric Chatellier
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
@Results({
        @Result(type = "agrosyst-json", name = "success")
})
public abstract class AbstractJsonAction extends AbstractAgrosystAction {

    private static final long serialVersionUID = 2293808209162340936L;

    /**
     * Method to override to get object data to render as json. Method HAS to be public because result support will use
     * this method.
     *
     * @return object to render as json
     */
    public abstract Object getJsonData();

}
