package fr.inra.agrosyst.web.actions;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AbstractAgrosystAction.java 672 2013-07-23 14:35:25Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/AbstractAgrosystAction.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Calendar;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.interceptor.ParameterAware;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.nuiton.util.PagerBean;
import org.nuiton.util.PagerBeanUtil;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.context.NavigationContextService;
import fr.inra.agrosyst.web.AgrosystWebApplicationContext;
import fr.inra.agrosyst.web.AgrosystWebConfig;
import fr.inra.agrosyst.web.AgrosystWebSession;

/**
 * Toutes les actions Struts doivent hériter de cette classe.
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public abstract class AbstractAgrosystAction extends ActionSupport implements ServletRequestAware, ServletResponseAware,
        ParameterAware {

    private static final long serialVersionUID = 4829352350362628085L;

    // Injectés par fr.inra.agrosyst.web.AgrosystWebInterceptor
    protected AgrosystWebConfig config;
    protected AgrosystWebSession session;
    protected NavigationContextService navigationContextService;

    protected HttpServletRequest servletRequest;
    protected HttpServletResponse servletResponse;

    protected Map<String, String[]> parameters;

    protected static GsonBuilder gsonBuilder = new GsonBuilder();

    static {
        gsonBuilder.registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY);
        gsonBuilder.setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    /**
     * gson (can be used into non json action to initialize json data).
     */
    protected Gson gson;

    public Gson getGson() {
        if (gson == null) {
            gson = gsonBuilder.create();
        }
        return gson;
    }

    public String toJson(Object element) {
        return getGson().toJson(element);
    }

    @Override
    public void setServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    @Override
    public void setServletResponse(HttpServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    @Override
    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    public void setConfig(AgrosystWebConfig config) {
        this.config = config;
    }

    public void setSession(AgrosystWebSession session) {
        this.session = session;
    }

    public void setNavigationContextService(NavigationContextService navigationContextService) {
        this.navigationContextService = navigationContextService;
    }

    // Ne pas supprimer, méthode utilisée depuis les JSP
    public AgrosystWebConfig getConfig() {
        return config;
    }

    // Ne pas supprimer, méthode utilisée depuis les JSP
    public AgrosystWebSession getSession() {
        return session;
    }

    protected NavigationContext getNavigationContext() {
        NavigationContext navigationContext = session.getNavigationContext();

        // 'dirty' permet de savoir si les données du contexte doivent être validées
        boolean dirty = false;
        if (navigationContext == null) {

            // Lecture du cookie
            navigationContext = readNavigationContextCookie();
            dirty = true;

            // Pas de cookie trouvé, création du contexte de navigation par défaut
            if (navigationContext == null) {
                navigationContext = new NavigationContext();
                dirty = false;
            }

            if (navigationContext.getCampaigns().isEmpty()) {
                int campaign = Calendar.getInstance().get(Calendar.YEAR) + 1;
                navigationContext.setCampaigns(Sets.newHashSet(campaign));
            }
        }

        if (dirty) {
            navigationContext = verifyAndSaveNavigationContext(navigationContext);
        }
        return navigationContext;
    }

    protected NavigationContext verifyAndSaveNavigationContext(NavigationContext navigationContext) {
        NavigationContext newNavigationContext = navigationContextService.verify(navigationContext);
        session.setNavigationContext(newNavigationContext);
        writeNavigationContextCookie(newNavigationContext);
        return newNavigationContext;
    }

    protected NavigationContext readNavigationContextCookie() {
        NavigationContext result = null;
        if (servletRequest != null) {
            Cookie[] cookies = servletRequest.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (AgrosystWebConfig.NAVIGATION_CONTEXT_COOKIE_NAME.equals(cookie.getName())) {
                        result = new Gson().fromJson(cookie.getValue(), NavigationContext.class);
                        break;
                    }
                }
            }
        }
        return result;
    }

    protected void writeNavigationContextCookie(NavigationContext navigationContext) {
        Cookie cookie = new Cookie(AgrosystWebConfig.NAVIGATION_CONTEXT_COOKIE_NAME, getGson().toJson(navigationContext));
        cookie.setPath(servletRequest.getContextPath());
        servletResponse.addCookie(cookie);
    }

    public RichNavigationContext getRichNavigationContext() {
        NavigationContext navigationContext = getNavigationContext();
        RichNavigationContext result = new RichNavigationContext(navigationContext, navigationContextService);
        return result;
    }

    public void initForInput() {

    }

}
