/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebTransactionFilter.java 569 2013-07-18 15:39:23Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebTransactionFilter.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.web.filter.TopiaTransactionFilter;

import com.google.common.base.Preconditions;

/**
 * Filter managing unique transaction for each servlet request.
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class AgrosystWebTransactionFilter extends TopiaTransactionFilter {

    private static final Log log = LogFactory.getLog(AgrosystWebTransactionFilter.class);

    public static final String MISSING_APPLICATION_CONTEXT =
            AgrosystWebApplicationContext.class.getSimpleName() + " not found. You probably forgot to" +
                    " register " + AgrosystWebApplicationListener.class.getName() + " in your web.xml";

    protected AgrosystWebApplicationContext applicationContext;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

        super.init(filterConfig);

        if (log.isInfoEnabled()) {
            log.info("Initializing Agrosyst Web Transaction Filter");
        }

        applicationContext = (AgrosystWebApplicationContext)
                filterConfig.getServletContext().getAttribute(
                        AgrosystWebApplicationContext.APPLICATION_CONTEXT_PARAMETER);

        Preconditions.checkState(applicationContext != null, MISSING_APPLICATION_CONTEXT);
    }

    @Override
    protected TopiaContext beginTransaction(ServletRequest request) throws TopiaRuntimeException {
        return applicationContext.newTransaction();
    }

//    @Override
//    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
//
//        @Deprecated // TODO AThimel 13/06/13 Dans l'optique d'un mode distant, ça n'a rien à faire ici
//        DefaultServiceContext serviceContext = new DefaultServiceContext(applicationContext.getServiceConfig(), new Supplier<TopiaContext>() {
//            @Override
//            public TopiaContext get() {
//                return applicationContext.newTransaction();
//            }
//        });
//        request.setAttribute(ServiceFactory.class.getName(), serviceContext.getServiceFactory());
//        super.doFilter(request, response, chain);
//    }

    @Override
    public void destroy() {
        if (log.isInfoEnabled()) {
            log.info("Destroy Filter");
        }
    }

}
