package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebSession.java 665 2013-07-23 12:07:45Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebSession.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Set;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.users.UserDto;

/**
 * Unique objet en session qui regroupe les données de session de l'utilisateur
 *
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class AgrosystWebSession {

    /**
     * Clé utilisée pour stocker l'instance de {@link AgrosystWebSession} dans la map de session HTTP.
     */
    public static final String SESSION_PARAMETER = "agrosystSession";

    protected NavigationContext navigationContext;

    protected UserDto authenticatedUser;

    protected Set<String> messages = Sets.newLinkedHashSet();

    protected Set<String> errorMessages = Sets.newLinkedHashSet();

    public NavigationContext getNavigationContext() {
        return navigationContext;
    }

    public void setNavigationContext(NavigationContext navigationContext) {
        this.navigationContext = navigationContext;
    }

    public UserDto getAuthenticatedUser() {
        return authenticatedUser;
    }

    public void setAuthenticatedUser(UserDto authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }

    public void addErrorMessage(String error) {
        this.errorMessages.add(error);
    }

    public Set<String> getMessages() {
        return messages;
    }

    public Set<String> getErrorMessages() {
        return errorMessages;
    }

    public void clearMessages() {
        messages.clear();
    }

    public void clearErrorMessages() {
        errorMessages.clear();
    }
}
