/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebConfig.java 590 2013-07-19 21:10:57Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebConfig.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

package fr.inra.agrosyst.web;

import org.nuiton.util.config.ApplicationConfig;
import org.nuiton.util.config.ArgumentsParserException;
import org.nuiton.util.config.ConfigOptionDef;

/**
 * Web module configuration.
 *
 * @author Eric Chatellier
 */
public class AgrosystWebConfig {

    /**
     * Configuration filename.
     */
    protected static final String AGROSYST_CONF_FILENAME = "agrosyst.properties";

    public static final String NAVIGATION_CONTEXT_COOKIE_NAME = "nav.context";

    /**
     * Delegate application config.
     */
    public ApplicationConfig config;

    public AgrosystWebConfig() {
        config = new ApplicationConfig();
        config.loadDefaultOptions(WebConfigOption.values());
    }

    public void parse(String... args) {
        try {
            config.parse(args);
        } catch (ArgumentsParserException ex) {
            throw new RuntimeException("Can't read configuration", ex);
        }
    }

    public String getApplicationVersion() {
        return config.getOption(WebConfigOption.APPLICATION_VERSION.key);
    }

    public int getListResultsPerPage() {
        return config.getOptionAsInt(WebConfigOption.LIST_RESULTS_PER_PAGE.key);
    }

    static enum WebConfigOption implements ConfigOptionDef {

        FILENAME(ApplicationConfig.CONFIG_FILE_NAME, AGROSYST_CONF_FILENAME),

        APPLICATION_VERSION("agrosyst.web.application.version", null),

        LIST_RESULTS_PER_PAGE("agrosyst.web.list.results.per.page", "10");

        private String key;
        private String defaultValue;

        private WebConfigOption(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getKey() {
            return key;
        }

        @Override
        public String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public Class<?> getType() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public void setDefaultValue(String defaultValue) {

        }

        @Override
        public void setTransient(boolean isTransient) {

        }

        @Override
        public void setFinal(boolean isFinal) {

        }
    }
}
