package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebApplicationListener.java 644 2013-07-23 00:05:43Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebApplicationListener.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

import com.google.common.base.Supplier;

import fr.inra.agrosyst.api.services.referentiels.ImportService;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.services.DefaultServiceContext;
import fr.inra.agrosyst.services.demo.DemoDatas;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class AgrosystWebApplicationListener implements ServletContextListener {

    private static final Log log = LogFactory.getLog(AgrosystWebApplicationListener.class);

    protected AgrosystWebApplicationContext context;

    @Override
    public void contextInitialized(ServletContextEvent sce) {

        if (log.isInfoEnabled()) {
            log.info("Initializing Agrosyst Web Module");
        }

//        if (log.isInfoEnabled()) {
//            log.info("Initializing I18n...");
//        }
//
//        I18nInitializer initializer = new DefaultI18nInitializer("agrosyst-web");
//        initializer.setMissingKeyReturnNull(true);
//        I18n.init(initializer, Locale.FRANCE);


        context = new AgrosystWebApplicationContext();
        context.init();

        sce.getServletContext().setAttribute(AgrosystWebApplicationContext.APPLICATION_CONTEXT_PARAMETER, context);

        checkForDemoDatas();
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info("Destroy Agrosyst Web Module");
        }

        context.close();
    }

    protected void checkForDemoDatas() {
        AgrosystServiceConfig serviceConfig = context.getServiceConfig();
        if (serviceConfig.isDemoModeEnabled()) {
            TopiaContext transaction = null;
            try {

                DefaultServiceContext serviceContext = new DefaultServiceContext(serviceConfig, new Supplier<TopiaContext>() {
                    @Override
                    public TopiaContext get() {
                        return context.newTransaction();
                    }
                });
                ImportService importService = serviceContext.newService(ImportService.class);
                transaction = serviceContext.getTransaction();
                DemoDatas demoDatas = new DemoDatas(transaction, importService);
                demoDatas.checkForDemoCommunes();
                demoDatas.checkForDemoMateriels();
                demoDatas.checkForDemoSolsArvalis();
                demoDatas.checkForDemoDatas();

            } catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error("Unable to create demo datas", eee);
                }
            } finally {
                if (transaction != null) {
                    try {
                        transaction.closeContext();
                    } catch (TopiaException te) {
                        log.error("Unable to close transaction", te);
                    }
                }
            }
        }
    }

}
