package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebApplicationContext.java 569 2013-07-18 15:39:23Z athimel $
 * $HeadURL: https://forge.codelutin.com/svn/agrosyst/tags/agrosyst-0.2/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebApplicationContext.java $
 * %%
 * Copyright (C) 2013 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Properties;

import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaRuntimeException;

import fr.inra.agrosyst.api.entities.AgrosystDAOHelper;
import fr.inra.agrosyst.services.AgrosystServiceConfig;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class AgrosystWebApplicationContext {

    public static final String APPLICATION_CONTEXT_PARAMETER = AgrosystWebApplicationContext.class.getName();

    @Deprecated // TODO AThimel 13/06/13 Dans l'optique d'un mode distant, ça n'a rien à faire ici
    protected AgrosystServiceConfig serviceConfig;

    @Deprecated // TODO AThimel 13/06/13 Dans l'optique d'un mode distant, ça n'a rien à faire ici
    protected TopiaContext rootContext;

    protected AgrosystWebConfig webConfig;

    public void init() {

        webConfig = new AgrosystWebConfig();
        webConfig.parse();

        serviceConfig = new AgrosystServiceConfig();
        serviceConfig.parse();
        Properties rootProperties = serviceConfig.getFlatOptions();
        rootProperties.setProperty(TopiaContextFactory.CONFIG_PERSISTENCE_CLASSES, AgrosystDAOHelper.getImplementationClassesAsString());

        try {
            rootContext = TopiaContextFactory.getContext(rootProperties);
        } catch (TopiaNotFoundException tnfe) {
            throw new TopiaRuntimeException("Unable to initialize TopiaContext", tnfe);
        }
    }

    public AgrosystServiceConfig getServiceConfig() {
        return serviceConfig;
    }

    public AgrosystWebConfig getWebConfig() {
        return webConfig;
    }

    public TopiaContext newTransaction() {
        TopiaContext tx = rootContext.beginTransaction();
        return tx;
    }

    public void close() {
        if (rootContext != null) {
            rootContext.closeContext();
        }
    }
}
