package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: SaveEntityRoles.java 3460 2014-02-25 09:52:01Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/SaveEntityRoles.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.lang.reflect.Type;
import java.util.List;

import com.google.gson.reflect.TypeToken;

import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.services.security.UserRoleDto;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class SaveEntityRoles extends AbstractJsonAction {

    private static final long serialVersionUID = -7507420510086126834L;

    protected RoleType roleType;

    protected String entityCode;

    protected List<UserRoleDto> roles;

    public void setRoleType(RoleType roleType) {
        this.roleType = roleType;
    }

    public void setEntityCode(String entityCode) {
        this.entityCode = entityCode;
    }

    public void setRolesJson(String rolesJson) {
        Type type = new TypeToken<List<UserRoleDto>>() {
        }.getType();
        this.roles = getGson().fromJson(rolesJson, type);
    }

    @Override
    public String execute() throws Exception {
        authorizationService.saveEntityUserRoles(roleType, entityCode, roles);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return null;
    }

}
