package fr.inra.agrosyst.web.actions.security;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: EditEntityRolesRaw.java 3493 2014-02-26 11:40:15Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/security/EditEntityRolesRaw.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;

import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.security.UserRoleDto;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class EditEntityRolesRaw extends AbstractAgrosystAction {

    private static final long serialVersionUID = -8587272104576117396L;

    protected transient GrowingSystemService growingSystemService;

    protected RoleType roleType;
    protected String entityCode;
    protected List<UserRoleDto> roles;
    protected List<Integer> availableCampaigns;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setRoleType(RoleType roleType) {
        this.roleType = roleType;
    }

    public void setEntityCode(String entityCode) {
        this.entityCode = entityCode;
    }

    @Override
    public String execute() throws Exception {

        readOnly = true;
        boolean loadRoles = true;
        switch (roleType) {
            case DOMAIN_RESPONSIBLE:
                readOnly = !authorizationService.isDomainAdministrable(entityCode);
//                if (readOnly) {
//                    loadRoles = !authorizationService.shouldAnonymizeDomainByCode(entityCode);
//                }
                break;
            case GROWING_PLAN_RESPONSIBLE:
                readOnly = !authorizationService.isGrowingPlanAdministrable(entityCode);
//                if (readOnly) {
//                    loadRoles = !authorizationService.shouldAnonymizeGrowingPlanByCode(entityCode);
//                }
                break;
            case GS_DATA_PROCESSOR:
                readOnly = !authorizationService.isGrowingSystemAdministrable(entityCode);
                break;
            default:
                throw new UnsupportedOperationException("Unexpected role type: " + roleType);
        }

//        if (loadRoles) {
            roles = authorizationService.getEntityRoles(roleType, entityCode);
//        }

        if (RoleType.GS_DATA_PROCESSOR.equals(roleType)) {
            availableCampaigns = growingSystemService.getGrowingSystemCampaigns(entityCode);
        } else {
            availableCampaigns = Lists.newArrayList();
        }

        return SUCCESS;
    }

    public RoleType getRoleType() {
        return roleType;
    }

    public String getEntityCode() {
        return entityCode;
    }

    public List<UserRoleDto> getRoles() {
        return roles;
    }

    public List<Integer> getAvailableCampaigns() {
        return availableCampaigns;
    }

    public Map<RoleType, String> getRoleTypes() {
        return getEnumAsMap(RoleType.values());
    }

}
