package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PracticedSystemsDuplicate.java 3490 2014-02-26 09:44:01Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/PracticedSystemsDuplicate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Duplicate single domain.
 * 
 * @author Eric Chatellier
 */
public class PracticedSystemsDuplicate extends AbstractAgrosystAction {

    private static final long serialVersionUID = 3763987457979325440L;

    /** Single practiced system to duplicate. */
    protected String practicedSystemId;

    protected String growingSystemId;

    /** Service. */
    protected transient PracticedSystemService practicedSystemService;

    /** Practiced system. */
    protected PracticedSystem practicedSystem;

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setPracticedSystemId(String practicedSystemId) {
        this.practicedSystemId = practicedSystemId;
    }

    @Override
    @Action(results = {
            @Result(type = "redirectAction", params = {"actionName", "practiced-systems-edit-input", "practicedSystemTopiaId", "${practicedSystem.topiaId}"})})
    public String execute() throws Exception {
        practicedSystem = practicedSystemService.duplicatePracticedSystem(practicedSystemId, growingSystemId);
        return SUCCESS;
    }

    public PracticedSystem getPracticedSystem() {
        return practicedSystem;
    }
}
