package fr.inra.agrosyst.web.actions.practiced;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadFertiOrgaJson.java 3024 2014-01-31 13:35:17Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/practiced/LoadFertiOrgaJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import fr.inra.agrosyst.api.entities.referential.RefFertiOrga;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * @author David Cossé
 */
public class LoadFertiOrgaJson extends AbstractJsonAction {

    private static final long serialVersionUID = 6788304545377822497L;

    protected List<RefFertiOrga> refFertiTypesEffluents;

    protected transient ReferentialService referentialService;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    @Override
    public String execute() {
        refFertiTypesEffluents = referentialService.findAllActiveOrganicProductTypes();
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return refFertiTypesEffluents;
    }
}
