package fr.inra.agrosyst.web.actions.performances;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PerformancesEditJson.java 3427 2014-02-24 10:15:49Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/performances/PerformancesEditJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Collections;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.struts2.convention.annotation.Action;

import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemFilter;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

/**
 * Actions json de la page d'edition des performances.
 * 
 * @author Eric Chatellier
 */
public class PerformancesEditJson extends AbstractJsonAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 525633506544808582L;

    protected transient GrowingSystemService growingSystemService;
    
    protected transient PerformanceService performanceService;

    protected List<String> domainIds;
    
    protected List<String> growingSystemIds;
    
    protected List<String> plotIds;

    protected Object jsonData;

    public void setPerformanceService(PerformanceService performanceService) {
        this.performanceService = performanceService;
    }

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setDomainIds(List<String> domainIds) {
        this.domainIds = domainIds;
    }

    public void setGrowingSystemIds(List<String> growingSystemIds) {
        this.growingSystemIds = growingSystemIds;
    }

    public void setPlotIds(List<String> plotIds) {
        this.plotIds = plotIds;
    }

    @Action("performances-edit-growing-systems-list-json")
    public String listGrowingSystems() {
        if (CollectionUtils.isEmpty(domainIds)) {
            jsonData = Collections.emptyList();
        } else {
            GrowingSystemFilter growingSystemFilter = new GrowingSystemFilter();
            NavigationContext navigationContext2 = new NavigationContext(getNavigationContext());
            navigationContext2.setDomains(Sets.newHashSet(domainIds));
            growingSystemFilter.setNavigationContext(navigationContext2);
            jsonData = Sets.newLinkedHashSet(growingSystemService.getFilteredGrowingSystems(growingSystemFilter));
        }
        return SUCCESS;
    }
    
    @Action("performances-edit-plots-list-json")
    public String listPlots() {
        if (CollectionUtils.isEmpty(domainIds)) {
            jsonData = Collections.emptyList();
        } else {
            jsonData = performanceService.getPlots(domainIds);
        }
        return SUCCESS;
    }
    
    @Action("performances-edit-zones-list-json")
    public String listZones() {
        if (CollectionUtils.isEmpty(plotIds)) {
            jsonData = Collections.emptyList();
        } else {
            jsonData = performanceService.getZones(plotIds);
        }
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return jsonData;
    }
}
