package fr.inra.agrosyst.web.actions.performances;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: PerformancesDelete.java 3241 2014-02-14 09:40:30Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/performances/PerformancesDelete.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.performance.PerformanceService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class PerformancesDelete extends AbstractAgrosystAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = -1180723133330637375L;

    protected transient PerformanceService performanceService;

    protected List<String> performanceIds;

    protected boolean practiced;

    public void setPerformanceIds(List<String> performanceIds) {
        this.performanceIds = performanceIds;
    }

    public void setPracticed(boolean practiced) {
        this.practiced = practiced;
    }

    public void setPerformanceService(PerformanceService performanceService) {
        this.performanceService = performanceService;
    }

    @Action(results = {@Result(type = "redirectAction", params = {"actionName", "performances-list", "practiced", "${practiced}"})})
    public String execute() {
        performanceService.deletePerformance(performanceIds);
        return SUCCESS;
    }
    
    public boolean isPracticed() {
        return practiced;
    }
}
