package fr.inra.agrosyst.web.actions.networks;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: NetworksUnactivate.java 3161 2014-02-10 09:29:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/networks/NetworksUnactivate.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Désactivation multiple de réseaux.
 *
 * @author Eric Chatellier
 */
public class NetworksUnactivate extends AbstractAgrosystAction {

    private static final long serialVersionUID = 2031204987636332755L;

    protected transient NetworkService networkService;

    protected List<String> networkIds;

    protected boolean activate;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void setNetworkIds(List<String> networkIds) {
        this.networkIds = networkIds;
    }

    public void setActivate(boolean activate) {
        this.activate = activate;
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {
            "actionName", "networks-list"})})
    public String execute() throws Exception {
        networkService.unactivateNetworks(networkIds, activate);
        return SUCCESS;
    }

}
