package fr.inra.agrosyst.web.actions.networks;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: LoadNetworkJson.java 3241 2014-02-14 09:40:30Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/networks/LoadNetworkJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Set;

import fr.inra.agrosyst.api.services.network.NetworkService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class LoadNetworkJson extends AbstractJsonAction {

    private static final long serialVersionUID = -6530908333069318234L;

    protected transient NetworkService networkService;

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    protected String networkName;
    protected String networkTopiaId;

    protected Set<String> otherNetworks;

    @Override
    public String execute() throws Exception {
        otherNetworks = networkService.findNetworksByName(networkName, networkTopiaId);
        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return otherNetworks;
    }

    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }

    public void setNetworkTopiaId(String networkTopiaId) {
        this.networkTopiaId = networkTopiaId;
    }
}
