package fr.inra.agrosyst.web.actions.itk;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AbstractItkAction.java 2936 2014-01-28 09:05:37Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/itk/AbstractItkAction.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.BioAgressorType;
import fr.inra.agrosyst.api.entities.action.CapacityUnit;
import fr.inra.agrosyst.api.entities.action.FertiOrgaUnit;
import fr.inra.agrosyst.api.entities.action.MineralProductUnit;
import fr.inra.agrosyst.api.entities.action.OrganicProductUnit;
import fr.inra.agrosyst.api.entities.action.PhytoProductUnit;
import fr.inra.agrosyst.api.entities.action.SeedPlantUnit;
import fr.inra.agrosyst.api.entities.action.SeedType;
import fr.inra.agrosyst.api.entities.action.YealdCategory;
import fr.inra.agrosyst.api.entities.action.YealdUnit;
import fr.inra.agrosyst.api.entities.referential.RefFertiOrga;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.services.itk.Itk;
import fr.inra.agrosyst.api.services.input.Inputs;
import fr.inra.agrosyst.api.services.referential.MineralProductType;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public abstract class AbstractItkAction extends AbstractAgrosystAction {

    private static final long serialVersionUID = -6057182538439163217L;

    protected ReferentialService referentialService;



    protected List<MineralProductType> mineralProductTypes;
    protected List<RefFertiOrga> organicProductTypes;
    protected Map<AgrosystInterventionType, List<String>> actaTreatmentProductTypes;
    protected List<RefInterventionAgrosystTravailEDI> agrosystActionsFullList;

    public final void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    @Override
    protected void initForInput() {

        agrosystActionsFullList = referentialService.findAllActiveAgrosystActions();
        mineralProductTypes = referentialService.findAllActiveMineralProductTypes();
        organicProductTypes = referentialService.findAllActiveOrganicProductTypes();
        actaTreatmentProductTypes = referentialService.getAllActiveActaTreatmentProductTypes();

        super.initForInput();
    }



    ////////////// ITK specific data //////////////

    public Map<YealdCategory, String> getYealdCategories(){
        return getEnumAsMap(YealdCategory.values());
    }

    public Map<CapacityUnit, String> getCapacityUnits(){
        return getEnumAsMap(CapacityUnit.values());
    }

    public List<MineralProductType> getMineralProductTypes() {
        return mineralProductTypes;
    }

    public Map<BioAgressorType, String> getTreatmentTargetCategories() {
        return getEnumAsMap(Itk.TREATMENT_TARGET_CATEGORIES);
    }

    public Map<SeedType, String> getSeedTypes() {
        return getEnumAsMap(SeedType.values());
    }

    public Map<SeedPlantUnit, String> getSeedPlantUnits() {
        return getEnumAsMap(SeedPlantUnit.values());
    }

    public Map<YealdUnit, String> getYealdUnits() {
        return getEnumAsMap(YealdUnit.values());
    }

    public List<RefFertiOrga> getOrganicProductTypes() {
        return organicProductTypes;
    }

    public Map<MineralProductUnit, String> getMineralProductUnits() {
        return getEnumAsMap(MineralProductUnit.values());
    }

    public Map<OrganicProductUnit, String> getOrganicProductUnits() {
        return getEnumAsMap(OrganicProductUnit.values());
    }

    public Map<PhytoProductUnit, String> getPhytoProductUnits() {
        return getEnumAsMap(PhytoProductUnit.values());
    }

    public Map<AgrosystInterventionType, List<String>> getActaTreatmentProductTypes() {
        return actaTreatmentProductTypes;
    }

    public Map<FertiOrgaUnit, String> getFertiOrgaUnits() {
        return getEnumAsMap(FertiOrgaUnit.values());
    }

    public Map<AgrosystInterventionType, String> getInputTypesLabels() {
        Map<AgrosystInterventionType, String> result = Maps.newLinkedHashMap();
        for (AgrosystInterventionType value : Inputs.INPUT_TYPES) {
            String key = "InputType." + value.name();
            String trans = getText(key);
            result.put(value, trans);
        }
        return result;
    }

    public List<RefInterventionAgrosystTravailEDI> getAgrosystActionsFullList() {
        return agrosystActionsFullList;
    }

}
