package fr.inra.agrosyst.web.actions.growingplans;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingPlansListJson.java 3546 2014-02-27 22:04:06Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingplans/GrowingPlansListJson.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Set;

import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanDto;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanFilter;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;

public class GrowingPlansListJson extends AbstractJsonAction {

    private static final long serialVersionUID = -2087447831007638801L;

    protected transient GrowingPlanService growingPlanService;

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    protected boolean fromNavigationContextChoose = false;
    protected String filter;
    protected Set<Integer> selectedCampaigns = Sets.newHashSet();
    protected Set<String> selectedNetworks = Sets.newHashSet();
    protected Set<String> selectedDomains = Sets.newHashSet();

    protected ResultList<GrowingPlanDto> growingPlans;

    public void setFromNavigationContextChoose(boolean fromNavigationContextChoose) {
        this.fromNavigationContextChoose = fromNavigationContextChoose;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setSelectedCampaigns(Set<Integer> selectedCampaigns) {
        this.selectedCampaigns = selectedCampaigns;
    }

    public void setSelectedNetworks(Set<String> selectedNetworks) {
        this.selectedNetworks = selectedNetworks;
    }

    public void setSelectedDomains(Set<String> selectedDomains) {
        this.selectedDomains = selectedDomains;
    }

    @Override
    public String execute() {
        GrowingPlanFilter growingPlanFilter = getGson().fromJson(filter, GrowingPlanFilter.class);
        NavigationContext navigationContext;
        if (fromNavigationContextChoose) {
            navigationContext = new NavigationContext();
            navigationContext.setCampaigns(selectedCampaigns);
            navigationContext.setNetworks(selectedNetworks);
            navigationContext.setDomains(selectedDomains);
        } else {
            navigationContext = getNavigationContext();
        }
        growingPlanFilter.setNavigationContext(navigationContext);
        growingPlans = growingPlanService.getFilteredGrowingPlansDto(growingPlanFilter);

        return SUCCESS;
    }

    @Override
    public Object getJsonData() {
        return growingPlans;
    }

}
