package fr.inra.agrosyst.web.actions.growingplans;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingPlansList.java 3409 2014-02-21 23:42:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingplans/GrowingPlansList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanDto;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanFilter;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Action d'affichage de la liste paginée des dispositifs.
 * 
 * @author Eric Chatellier
 */
public class GrowingPlansList extends AbstractAgrosystAction {

    private static final long serialVersionUID = -430109839071419528L;

    protected transient GrowingPlanService growingPlanService;
    
    protected transient DomainService domainService;

    /** Init growing plans. */
    protected ResultList<GrowingPlanDto> growingPlans;

    /** Domain list (for duplicate option). */
    protected List<Domain> domains;

    protected GrowingPlanFilter growingPlanFilter;

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    public String execute() throws Exception {

        NavigationContext navigationContext = getNavigationContext();
        
        // get init growing plans
        growingPlanFilter = new GrowingPlanFilter();
        growingPlanFilter.setNavigationContext(navigationContext);
        growingPlanFilter.setPageSize(getConfig().getListResultsPerPage());
        growingPlanFilter.setActive(Boolean.TRUE);
        growingPlans = growingPlanService.getFilteredGrowingPlansDto(growingPlanFilter);
        
        // get all active domains (duplicate action) // FIXME AThimel 21/02/14 !?!?!? WTFFFF !?!?!?
        DomainFilter domainFilter = new DomainFilter();  // FIXME AThimel 21/02/14 !?!?!? WTFFFF !?!?!?
        domainFilter.setNavigationContext(navigationContext); // FIXME AThimel 21/02/14 !?!?!? WTFFFF !?!?!?
        domainFilter.setActive(Boolean.TRUE); // FIXME AThimel 21/02/14 !?!?!? WTFFFF !?!?!?
        domainFilter.setPageSize(DomainFilter.ALL_PAGE_SIZE); // FIXME AThimel 21/02/14 !?!?!? WTFFFF !?!?!?
        ResultList<Domain> domainListResult = domainService.getFilteredDomains(domainFilter); // FIXME AThimel 21/02/14 !?!?!? WTFFFF !?!?!?
        domains = domainListResult.getElements(); // FIXME AThimel 21/02/14 !?!?!? WTFFFF !?!?!?

        return SUCCESS;
    }

    public ResultList<GrowingPlanDto> getGrowingPlans() {
        return growingPlans;
    }

    public List<Domain> getDomains() {
        return domains;
    }

    public Map<TypeDEPHY, String> getTypes() {
        return getEnumAsMap(TypeDEPHY.values());
    }

    public GrowingPlanFilter getGrowingPlanFilter() {
        return growingPlanFilter;
    }
}
