package fr.inra.agrosyst.web.actions.growingplans;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GrowingPlansEdit.java 3445 2014-02-24 15:48:36Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/growingplans/GrowingPlansEdit.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanImpl;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class GrowingPlansEdit extends AbstractAgrosystAction implements Preparable {

    private static final long serialVersionUID = -889011367401120504L;

    private static final String REQUIRED_FIELD = "Champ obligatoire";

    protected transient DomainService domainService;

    protected transient GrowingPlanService growingPlanService;

    protected String growingPlanTopiaId;

    protected GrowingPlan growingPlan;

    protected LinkedHashMap<Integer, String> relatedGrowingPlans;

    protected LinkedHashSet<Domain> domains;

    protected String domainId;

    protected List<GrowingSystem> growingSystems;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setGrowingPlanService(GrowingPlanService growingPlanService) {
        this.growingPlanService = growingPlanService;
    }

    public void setGrowingPlanTopiaId(String growingPlanTopiaId) {
        this.growingPlanTopiaId = growingPlanTopiaId;
    }

    public GrowingPlan getGrowingPlan() {
        if (growingPlan == null) {
            // EChatellier 27/06/2013 Fais chier de devoir écrire ça, mais c'est la seule option pour ne pas avoir une grosse dose d'exceptions avec du paramsPrepareParams
            return new GrowingPlanImpl();
        }
        return growingPlan;
    }

    @Override
    public void prepare() throws Exception {
        if (StringUtils.isNotBlank(growingPlanTopiaId)) {
            // TODO AThimel 07/10/13 May be included directly in the service ?
            authorizationService.checkGrowingPlanReadable(growingPlanTopiaId);

            readOnly = !authorizationService.isGrowingPlanWritable(growingPlanTopiaId);
            if (readOnly) {
                notificationSupport.growingPlanNotWritable();
            }

            growingPlan = growingPlanService.getGrowingPlan(growingPlanTopiaId);

        } else {
            growingPlan = new GrowingPlanImpl();
        }
    }

    @Override
    @Action("growing-plans-edit-input")
    public String input() throws Exception {
        initForInput();
        return INPUT;
    }

    @Override
    protected void initForInput() {
        // warning, growingPlan's domain must always be part of domains set
        // even not selected be navigation context
        if (getGrowingPlan().getTopiaId() != null) {
            Set<Domain> domains = Collections.singleton(getGrowingPlan().getDomain());
            this.domains = Sets.newLinkedHashSet(domains);
            relatedGrowingPlans = growingPlanService.getRelatedGrowingPlans(getGrowingPlan().getCode());
            growingSystems = growingPlanService.getGrowingPlanGrowingSystems(getGrowingPlan().getTopiaId());
        } else {
            DomainFilter domainFilter = new DomainFilter();
            NavigationContext navigationContext = getNavigationContext();
            domainFilter.setNavigationContext(navigationContext);
            domainFilter.setActive(Boolean.TRUE);
            domainFilter.setPageSize(DomainFilter.ALL_PAGE_SIZE);
            ResultList<Domain> domainListResult = domainService.getFilteredDomains(domainFilter);
            domains = Sets.newLinkedHashSet(domainListResult.getElements());
        }
    }

//    protected AgrosystValidationState computeValidationState() {
//        Preconditions.checkNotNull(growingPlan);
//        AgrosystValidationState result = new AgrosystValidationState();
//        boolean userCanValidate = false;  // An object must be persisted first before been displayed
//        if (growingPlan.isPersisted()) {
//            userCanValidate = authorizationService.isGrowingPlanValidable(growingPlanTopiaId);
//            Date validationDate = growingPlan.getValidationDate();
//            result.setLastValidationDate(validationDate);
//            boolean dirty = !growingPlan.isValidated() || validationDate.before(growingPlan.getUpdateDate());
//            result.setDirty(dirty);
//        }
//        result.setUserHasValidationPermission(userCanValidate);
//        return result;
//    }

    @Override
    public void validate() {

        // Domaine
        if (StringUtils.isBlank(getGrowingPlan().getTopiaId()) && StringUtils.isBlank(domainId)) {
            addFieldError("domainId", REQUIRED_FIELD);
        }

        // Nom du dispositif
        if (StringUtils.isBlank(growingPlan.getName())) {
            addFieldError("growingPlan.name", REQUIRED_FIELD);
        }

        // Type de dispositif
        if (growingPlan.getType() == null) {
            addFieldError("growingPlan.type", REQUIRED_FIELD);
        }

        if (hasErrors()) {
            initForInput();
        }

    }

    @Action(results = { @Result(type = "redirectAction", params = {"actionName", "growing-plans-edit-input", "growingPlanTopiaId", "${growingPlan.topiaId}"})})
    @Override
    public String execute() throws Exception {
        // can define domain only during create action
        if (StringUtils.isBlank(getGrowingPlan().getTopiaId())) {
            Domain domain = domainService.getDomain(domainId);
            growingPlan.setDomain(domain);
        }
 
        growingPlan = growingPlanService.createOrUpdateGrowingPlan(growingPlan);
        notificationSupport.growingPlanSaved(growingPlan);

        if (Strings.isNullOrEmpty(growingPlanTopiaId)) {
            navigationContextEntityCreated(growingPlan);
        }

        return SUCCESS;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getDomainId() {
        return domainId;
    }

    public Collection<Domain> getDomains() {
        return domains;
    }

    /**
     * Get all the type that a a domain could be.
     * 
     * @return all the type
     */
    public Map<TypeDEPHY, String> getTypesDephy() {
        return getEnumAsMap(TypeDEPHY.values());
    }

    public LinkedHashMap<Integer, String> getRelatedGrowingPlans() {
        return relatedGrowingPlans;
    }

    public List<GrowingSystem> getGrowingSystems() {
        return growingSystems;
    }

}
