package fr.inra.agrosyst.web.actions.generic;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: GenericEntitiesList.java 3449 2014-02-24 16:52:35Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/generic/GenericEntitiesList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.entities.security.HashedValue;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class GenericEntitiesList extends AbstractAdminAction implements Preparable {

    private static final Log log = LogFactory.getLog(GenericEntitiesList.class);

    private static final long serialVersionUID = -2256628821672426679L;

    protected String genericClassName;

    protected List<String> properties;

    protected String entitiesJson;

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    @Override
    public void prepare() throws Exception {
        super.prepare();

        try {
            Class<?> klass = Class.forName(genericClassName);
            properties = service.getPropertiesFromString(genericClassName);

            ResultList<?> entities = service.listEntities(klass, null);

            if (klass.isEnum()) {
                properties.add("Traduction");
                for (Object entity : entities) {
                    Map<String, String> entityMap = (Map<String, String>) entity;
                    String name = entityMap.get("Valeur");
                    String traduction = getText(klass.getName() + "." + name);
                    entityMap.put("Traduction", traduction);
                }
            }

            entitiesJson = getGson().toJson(entities);
        } catch (ClassNotFoundException e) {
            if (log.isErrorEnabled()) {
                log.error("Un exception occured", e);
            }
            properties = Lists.newArrayList();
        }
    }

    @Override
    public String execute() throws Exception {
        checkIsAdmin();
        return SUCCESS;
    }

    public String getGenericClassName() {
        return genericClassName;
    }

    public String getEntitiesJson() {
        return entitiesJson;
    }

    public List<String> getProperties() {
        List<String> copy = Lists.newArrayList();
        if (properties != null) {
            copy.addAll(properties);
            copy.remove("active"); // active will be managed separately
        }
        return copy;
    }

    public int getPropertiesSize() {
        int result = 0;
        if (properties != null) {
            result = properties.size();
        }
        result++; // column active
        return result;
    }

    public boolean isReferential() {
        boolean result = genericClassName.startsWith("fr.inra.agrosyst.api.entities.referential.Ref");
        return result;
    }

    public boolean isHashedValues() {
        boolean result = HashedValue.class.getName().equals(genericClassName);
        return result;
    }

    public boolean isReferentialOrHashedValues() {
        return isReferential() || isHashedValues();
    }
}
