package fr.inra.agrosyst.web.actions.domains;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: DomainsList.java 3409 2014-02-21 23:42:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/domains/DomainsList.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Map;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * Domain list action.
 *
 * @author Arnaud Thimel (Code Lutin)
 */
public class DomainsList extends AbstractAgrosystAction {

    private static final long serialVersionUID = -359363226334437151L;

    protected DomainFilter domainFilter;

    protected transient DomainService domainService;

    protected ResultList<DomainDto> domains;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    public String execute() throws Exception {
        domainFilter = new DomainFilter();
        NavigationContext navigationContext = getNavigationContext();
        domainFilter.setNavigationContext(navigationContext);
        domainFilter.setPageSize(getConfig().getListResultsPerPage());
        domainFilter.setActive(Boolean.TRUE);
        domains = domainService.getFilteredDomainsDto(domainFilter);
        return SUCCESS;
    }

    public Map<DomainType, String> getTypes() {
        return getEnumAsMap(DomainType.values());
    }

    public DomainFilter getDomainFilter() {
        return domainFilter;
    }

    public ResultList<DomainDto> getDomains() {
        return domains;
    }

}
