package fr.inra.agrosyst.web.actions.auth;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: ForgottenPassword.java 3161 2014-02-10 09:29:12Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/auth/ForgottenPassword.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class ForgottenPassword extends AbstractAgrosystAction {

    private static final long serialVersionUID = 2328784341047848966L;

    protected transient UserService userService;

    protected String email;
    protected boolean reminderSent;

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String execute() throws Exception {

        reminderSent = userService.askForPasswordReminder(email);
        if (reminderSent) {
            addActionMessage("Email de récupération du mot de passe envoyé, consultez votre boîte mail");
        } else {
            addFieldError("email", "L'email indiqué n'est pas connu par le système");
        }
        return INPUT;
    }

    public String getEmail() {
        return email;
    }

    public boolean isReminderSent() {
        return reminderSent;
    }

}
