package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: RunImport.java 3270 2014-02-17 11:08:03Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/RunImport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.referential.*;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.api.services.referential.ImportService;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class RunImport extends AbstractAdminAction {

    private static final long serialVersionUID = 4130324772446717782L;

    private static final Log log = LogFactory.getLog(RunImport.class);

    protected transient ImportService importService;

    public void setImportService(ImportService importService) {
        this.importService = importService;
    }

    protected String genericClassName;
    protected Class<?> klass;

    protected File source1;
    protected File source2;

    protected String source1FileName;
    protected String source2FileName;

    protected String source1ContentType;
    protected String source2ContentType;

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public String getGenericClassName() {
        return genericClassName;
    }

    public void setSource1(File source1) {
        this.source1 = source1;
    }

    public void setSource2(File source2) {
        this.source2 = source2;
    }

    public void setSource1FileName(String source1FileName) {
        this.source1FileName = source1FileName;
    }

    public void setSource2FileName(String source2FileName) {
        this.source2FileName = source2FileName;
    }

    public void setSource1ContentType(String source1ContentType) {
        this.source1ContentType = source1ContentType;
    }

    public void setSource2ContentType(String source2ContentType) {
        this.source2ContentType = source2ContentType;
    }

    protected void required(File... sources) {
        if (sources != null) {
            int index = 0;
            for (File source : sources) {
                index++;
                if (source == null) {
                    addFieldError("source" + index, "Fichier manquant");
                }
            }
        }
    }

    @Override
    public void validate() {
        if (Strings.isNullOrEmpty(genericClassName)) {
            addFieldError("genericClassName", "Ce champ est obligatoire");
        }

        try {
            klass = Class.forName(genericClassName);
        } catch (ClassNotFoundException e) {
            addFieldError("genericClassName", "Classe non trouvée");
        }

        if (RefLocation.class.equals(klass) || RefSolArvalis.class.equals(klass)) {
            required(source1, source2);
        } else {
            required(source1);
        }

        super.validate();
    }

    @Override
    @Action(results = {@Result(type = "redirectAction", params = {"namespace", "/generic", "actionName", "generic-entities-list", "genericClassName", "${genericClassName}"})})
    public String execute() throws Exception {
        checkIsAdmin();

        ImportResult importResult = null;

        if (RefSolArvalis.class.equals(klass)) {
            importResult = importService.importSolArvalisCSV(
                    new FileInputStream(source1),
                    new FileInputStream(source2));
        }

        if (RefLocation.class.equals(klass)) {
            importResult = importService.importCommuneOsmCSV(
                    new FileInputStream(source1),
                    new FileInputStream(source2));
        }

        if (RefMaterielTraction.class.equals(klass)) {
            importResult = importService.importMaterielTracteursCSV(
                    new FileInputStream(source1));
        }

        if (RefMaterielIrrigation.class.equals(klass)) {
            importResult = importService.importMaterielIrrigationCSV(
                    new FileInputStream(source1));
        }

        if (RefMaterielAutomoteur.class.equals(klass)) {
            importResult = importService.importMaterielAutomoteursCSV(
                    new FileInputStream(source1));
        }

        if (RefMaterielOutil.class.equals(klass)) {
            importResult = importService.importMaterielOutilsCSV(
                    new FileInputStream(source1));
        }

        if (RefLegalStatus.class.equals(klass)) {
            importResult = importService.importLegalStatusCSV(
                    new FileInputStream(source1));
        }

        if (RefEspece.class.equals(klass)) {
            importResult = importService.importEspeces(
                    new FileInputStream(source1));
        }

        if (RefVarieteGeves.class.equals(klass)) {
            importResult = importService.importVarietesGeves(
                    new FileInputStream(source1));
        }

        if (RefEspeceToVariete.class.equals(klass)) {
            importResult = importService.importEspecesToVarietes(
                    new FileInputStream(source1));
        }

        if (RefOTEX.class.equals(klass)) {
            importResult = importService.importOtexCSV(
                    new FileInputStream(source1));
        }

        if (RefClonePlantGrape.class.equals(klass)) {
            importResult = importService.importClonesPlantGrape(
                    new FileInputStream(source1));
        }

        if (RefVarietePlantGrape.class.equals(klass)) {
            importResult = importService.importVarietesPlantGrape(
                    new FileInputStream(source1));
        }

        if (RefOrientationEDI.class.equals(klass)) {
            importResult = importService.importOrientationEdiCSV(
                    new FileInputStream(source1));
        }
        
        if (RefSolTextureGeppa.class.equals(klass)) {
            importResult = importService.importSolTextureGeppa(
                    new FileInputStream(source1));
        }
        
        if (RefParcelleZonageEDI.class.equals(klass)) {
            importResult = importService.importZonageParcelleEdi(
                    new FileInputStream(source1));
        }
        
        if (RefSolProfondeurIndigo.class.equals(klass)) {
            importResult = importService.importSolProfondeurIndigo(
                    new FileInputStream(source1));
        }

        if (RefSolCaracteristiqueIndigo.class.equals(klass)) {
            importResult = importService.importSolCarateristiquesIndigo(
                    new FileInputStream(source1));
        }
        
        if (RefAdventice.class.equals(klass)) {
            importResult = importService.importAdventices(
                    new FileInputStream(source1));
        }
        
        if (RefNuisibleEDI.class.equals(klass)) {
            importResult = importService.importNuisiblesEDI(
                    new FileInputStream(source1));
        }
        
        if (RefFertiMinUNIFA.class.equals(klass)) {
            importResult = importService.importFertiMinUNIFA(new FileInputStream(source1));
        }
        
        if (RefFertiOrga.class.equals(klass)) {
            importResult = importService.importFertiOrga(new FileInputStream(source1));
        }
        
        if (RefTypeTravailEDI.class.equals(klass)) {
            importResult = importService.importTypeTravailEdiCSV(new FileInputStream(source1));
        }
        
        if (RefInterventionAgrosystTravailEDI.class.equals(klass)) {
            importResult = importService.importInterventionAgrosystTravailEdiCSV(new FileInputStream(source1));
        }
        
        if (RefStadeEDI.class.equals(klass)) {
            importResult = importService.importStadesEdiCSV(new FileInputStream(source1));
        }
        
        if (RefUniteEDI.class.equals(klass)) {
            importResult = importService.importUniteEDI(new FileInputStream(source1));
        }
        
        if (RefStationMeteo.class.equals(klass)) {
            importResult = importService.importStationMeteo(new FileInputStream(source1));
        }
        
        if (RefGesCarburant.class.equals(klass)) {
            importResult = importService.importGesCarburants(new FileInputStream(source1));
        }
        if (RefGesEngrais.class.equals(klass)) {
            importResult = importService.importGesEngrais(new FileInputStream(source1));
        }
        if (RefGesPhyto.class.equals(klass)) {
            importResult = importService.importGesPhyto(new FileInputStream(source1));
        }
        if (RefGesSemence.class.equals(klass)) {
            importResult = importService.importGesSemences(new FileInputStream(source1));
        }
        if (RefNrjCarburant.class.equals(klass)) {
            importResult = importService.importNrjCarburants(new FileInputStream(source1));
        }
        if (RefNrjPhyto.class.equals(klass)) {
            importResult = importService.importNrjPhyto(new FileInputStream(source1));
        }
        if (RefNrjSemence.class.equals(klass)) {
            importResult = importService.importNrjSemences(new FileInputStream(source1));
        }
        if (RefNrjGesOutil.class.equals(klass)) {
            importResult = importService.importNrjGesOutils(new FileInputStream(source1));
        }
        if (RefMesure.class.equals(klass)) {
            importResult = importService.importMesure(new FileInputStream(source1));
        }

        if (RefSupportOrganeEDI.class.equals(klass)) {
            importResult = importService.importSupportOrganeEDI(new FileInputStream(source1));
        }

        if (RefStadeNuisibleEDI.class.equals(klass)) {
            importResult = importService.importStadeNuisibleEDI(new FileInputStream(source1));
        }
        if (RefTypeNotationEDI.class.equals(klass)) {
            importResult = importService.importTypeNotationEDI(new FileInputStream(source1));
        }
        if (RefValeurQualitativeEDI.class.equals(klass)) {
            importResult = importService.importValeurQualitativeEDI(new FileInputStream(source1));
        }
        if (RefUnitesQualifiantEDI.class.equals(klass)) {
            importResult = importService.importUnitesQualifiantEDI(new FileInputStream(source1));
        }

        if (RefActaSubstanceActive.class.equals(klass)) {
            importResult = importService.importActaSubstanceActive(new FileInputStream(source1));
        }

        if (RefProtocoleVgObs.class.equals(klass)) {
            importResult = importService.importProtocoleVgObs(new FileInputStream(source1));
        }
        
        if (RefElementVoisinage.class.equals(klass)) {
            importResult = importService.importElementVoisinage(new FileInputStream(source1));
        }

        if (RefPhytoSubstanceActiveIphy.class.equals(klass)) {
            importResult = importService.importPhytoSubstanceActiveIphy(new FileInputStream(source1));
        }

        if (RefTypeAgriculture.class.equals(klass)) {
            importResult = importService.importTypeAgriculture(new FileInputStream(source1));
        }

        if (RefActaGroupeCultures.class.equals(klass)) {
            importResult = importService.importActaGroupeCultures(new FileInputStream(source1));
        }
        
        if (RefActaDosageSPC.class.equals(klass)) {
            importResult = importService.importActaDosageSpc(new FileInputStream(source1));
        }
        
        if (RefSaActaIphy.class.equals(klass)) {
            importResult = importService.importSaActaIphy(new FileInputStream(source1));
        }
        
        if (RefLienCulturesEdiActa.class.equals(klass)) {
            importResult = importService.importLienCulturesEdiActa(new FileInputStream(source1));
        }

        if (RefCultureEdiGroupeCouvSol.class.equals(klass)) {
            importResult = importService.importCultureEdiGroupeCouvSol(new FileInputStream(source1));
        }

        if (RefCouvSolAnnuelle.class.equals(klass)) {
            importResult = importService.importCouvSolAnnuelle(new FileInputStream(source1));
        }
        
        if (RefCouvSolPerenne.class.equals(klass)) {
            importResult = importService.importCouvSolPerenne(new FileInputStream(source1));
        }
        
        if (RefActaTraitementsProduit.class.equals(klass)) {
            importResult = importService.importActaTraitementsProduits(new FileInputStream(source1));
        }
        
        if (RefActaTraitementsProduitsCateg.class.equals(klass)) {
            importResult = importService.importActaTraitementsProduitsCateg(new FileInputStream(source1));
        }
        
        if (RefTraitSdC.class.equals(klass)) {
            importResult = importService.importTraitSdC(new FileInputStream(source1));
        }
        
        if (RefZoneClimatiqueIphy.class.equals(klass)) {
            importResult = importService.importZoneClimatiqueIphy(new FileInputStream(source1));
        }

        if (importResult != null) {
            if (importResult.hasErrors()) {
                for (String error : importResult.getErrors()) {
                    notificationSupport.importError("ÉCHEC : %s", error);
                }
            } else {
                notificationSupport.importSuccess("RÉUSSITE : Import terminé en %dms. %d créé(s) - %d modifié(s) - %d supprimé(s) - %d ignoré(s)",
                        importResult.getDuration(),
                        importResult.getCreated(),
                        importResult.getUpdated(),
                        importResult.getDeleted(),
                        importResult.getIgnored());
            }
        } else if (log.isWarnEnabled()) {
            log.warn("Can't find valid export for class " + klass);
        }
        return SUCCESS;
    }

}
