package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: RunExport.java 3480 2014-02-25 17:12:41Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/RunExport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.List;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.inra.agrosyst.api.entities.referential.*;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.referential.ExportService;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class RunExport extends AbstractAdminAction {

    private static final Log log = LogFactory.getLog(RunExport.class);

    private static final long serialVersionUID = -5821886179843474360L;

    protected transient ExportService exportService;

    public void setImportService(ExportService exportService) {
        this.exportService = exportService;
    }

    protected String genericClassName;
    protected List<String> entityIds;
    protected boolean emptyFile;

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public String getGenericClassName() {
        return genericClassName;
    }

    public void setEntityIds(List<String> entityIds) {
        this.entityIds = entityIds;
    }

    public void setEmptyFile(boolean emptyFile) {
        this.emptyFile = emptyFile;
    }

    @Override
    @Action(results= {@Result(type="stream", params={"contentType", "text/csv",
            "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        checkIsAdmin();
        return SUCCESS;
    }
    
    public InputStream getInputStream() {
        InputStream inputStream = null;
        try {
            Class<?> klass = Class.forName(genericClassName);

            if (emptyFile) {
                entityIds = Lists.newArrayListWithCapacity(0);
            }

            if (RefSolArvalis.class.equals(klass)) {
                inputStream = exportService.exportSolArvalisCSV(entityIds);
            }

            /*if (RefLocation.class.equals(klass)) {
                can't export this one
            }*/

            if (RefMaterielTraction.class.equals(klass)) {
                inputStream = exportService.exportMaterielTracteursCSV(entityIds);
            }

            if (RefMaterielIrrigation.class.equals(klass)) {
                inputStream = exportService.exportMaterielIrrigationCSV(entityIds);
            }

            if (RefMaterielAutomoteur.class.equals(klass)) {
                inputStream = exportService.exportMaterielAutomoteursCSV(entityIds);
            }

            if (RefMaterielOutil.class.equals(klass)) {
                inputStream = exportService.exportMaterielOutilsCSV(entityIds);
            }

            if (RefLegalStatus.class.equals(klass)) {
                inputStream = exportService.exportLegalStatusCSV(entityIds);
            }

            if (RefEspece.class.equals(klass)) {
                inputStream = exportService.exportEspeces(entityIds);
            }

            if (RefVarieteGeves.class.equals(klass)) {
                inputStream = exportService.exportVarietesGeves(entityIds);
            }

            if (RefEspeceToVariete.class.equals(klass)) {
                inputStream = exportService.exportEspecesToVarietes(entityIds);
            }

            if (RefOTEX.class.equals(klass)) {
                inputStream = exportService.exportOtexCSV(entityIds);
            }

            if (RefClonePlantGrape.class.equals(klass)) {
                inputStream = exportService.exportClonesPlantGrape(entityIds);
            }

            if (RefVarietePlantGrape.class.equals(klass)) {
                inputStream = exportService.exportVarietesPlantGrape(entityIds);
            }

            if (RefOrientationEDI.class.equals(klass)) {
                inputStream = exportService.exportOrientationEdiCSV(entityIds);
            }

            if (RefSolTextureGeppa.class.equals(klass)) {
                inputStream = exportService.exportSolTextureGeppa(entityIds);
            }

            if (RefParcelleZonageEDI.class.equals(klass)) {
                inputStream = exportService.exportZonageParcelleEdi(entityIds);
            }

            if (RefSolProfondeurIndigo.class.equals(klass)) {
                inputStream = exportService.exportSolProfondeurIndigo(entityIds);
            }

            if (RefSolCaracteristiqueIndigo.class.equals(klass)) {
                inputStream = exportService.exportSolCarateristiquesIndigo(entityIds);
            }
            
            if (RefAdventice.class.equals(klass)) {
                inputStream = exportService.exportAdventices(entityIds);
            }
            
            if (RefNuisibleEDI.class.equals(klass)) {
                inputStream = exportService.exportNuisiblesEDI(entityIds);
            }
            
            if (RefFertiEngraisorg.class.equals(klass)) {
                inputStream = exportService.exportFertiEngraisOrg(entityIds);
            }
            
            if (RefFertiMinUNIFA.class.equals(klass)) {
                inputStream = exportService.exportFertiMinUNIFA(entityIds);
            }
            
            if (RefFertiOrga.class.equals(klass)) {
                inputStream = exportService.exportFertiOrga(entityIds);
            }

            if (RefTypeTravailEDI.class.equals(klass)) {
                inputStream = exportService.exportTypeTravailEdiCSV(entityIds);
            }
            
            if (RefInterventionAgrosystTravailEDI.class.equals(klass)) {
                inputStream = exportService.exportInterventionAgrosystTravailEdiCSV(entityIds);
            }
            
            if (RefStadeEDI.class.equals(klass)) {
                inputStream = exportService.exportStadesEdiCSV(entityIds);
            }
            
            if (RefUniteEDI.class.equals(klass)) {
                inputStream = exportService.exportUniteEDI(entityIds);
            }
            
            if (RefStationMeteo.class.equals(klass)) {
                inputStream = exportService.exportStationMeteo(entityIds);
            }
            
            if (RefFertiEngraisorg.class.equals(klass)) {
                inputStream = exportService.exportFertiEngraisOrg(entityIds);
            }
            
            if (RefGesCarburant.class.equals(klass)) {
                inputStream = exportService.exportGesCarburants(entityIds);
            }
            
            if (RefGesEngrais.class.equals(klass)) {
                inputStream = exportService.exportGesEngrais(entityIds);
            }
            
            if (RefGesPhyto.class.equals(klass)) {
                inputStream = exportService.exportGesPhyto(entityIds);
            }
            
            if (RefGesSemence.class.equals(klass)) {
                inputStream = exportService.exportGesSemences(entityIds);
            }
            
            if (RefNrjCarburant.class.equals(klass)) {
                inputStream = exportService.exportNrjCarburants(entityIds);
            }
            
            if (RefNrjEngrais.class.equals(klass)) {
                inputStream = exportService.exportNrjEngrais(entityIds);
            }

            if (RefNrjPhyto.class.equals(klass)) {
                inputStream = exportService.exportNrjPhyto(entityIds);
            }

            if (RefNrjSemence.class.equals(klass)) {
                inputStream = exportService.exportNrjSemences(entityIds);
            }

            if (RefNrjGesOutil.class.equals(klass)) {
                inputStream = exportService.exportNrjGesOutils(entityIds);
            }

            if (RefMesure.class.equals(klass)) {
                inputStream = exportService.exportMesure(entityIds);
            }

            if (RefSupportOrganeEDI.class.equals(klass)) {
                inputStream = exportService.exportSupportOrganeEDI(entityIds);
            }
            
            if (RefStadeNuisibleEDI.class.equals(klass)) {
                inputStream = exportService.exportStadeNuisibleEDI(entityIds);
            }
            
            if (RefTypeNotationEDI.class.equals(klass)) {
                inputStream = exportService.exportTypeNotationEDI(entityIds);
            }
            
            if (RefValeurQualitativeEDI.class.equals(klass)) {
                inputStream = exportService.exportValeurQualitativeEDI(entityIds);
            }
            
            if (RefUnitesQualifiantEDI.class.equals(klass)) {
                inputStream = exportService.exportUnitesQualifiantEDI(entityIds);
            }

            if (RefActaSubstanceActive.class.equals(klass)) {
                inputStream = exportService.exportActaSubstanceActive(entityIds);
            }

            if (RefProtocoleVgObs.class.equals(klass)) {
                inputStream = exportService.exportProtocoleVgObs(entityIds);
            }
            
            if (RefElementVoisinage.class.equals(klass)) {
                inputStream = exportService.exportElementVoisinage(entityIds);
            }
            
            if (RefPhytoSubstanceActiveIphy.class.equals(klass)) {
                inputStream = exportService.exportPhytoSubstanceActiveIphy(entityIds);
            }

            if (RefTypeAgriculture.class.equals(klass)) {
                inputStream = exportService.exportTypeAgriculture(entityIds);
            }

            if (RefActaGroupeCultures.class.equals(klass)) {
                inputStream = exportService.exportActaGroupeCultures(entityIds);
            }

            if (RefActaDosageSPC.class.equals(klass)) {
                inputStream = exportService.exportActaDosageSpc(entityIds);
            }

            if (RefSaActaIphy.class.equals(klass)) {
                inputStream = exportService.exportSaActaIphy(entityIds);
            }

            if (RefLienCulturesEdiActa.class.equals(klass)) {
                inputStream = exportService.exportLienCulturesEdiActa(entityIds);
            }

            if (RefCultureEdiGroupeCouvSol.class.equals(klass)) {
                inputStream = exportService.exportCultureEdiGroupeCouvSol(entityIds);
            }

            if (RefCouvSolAnnuelle.class.equals(klass)) {
                inputStream = exportService.exportCouvSolAnnuelle(entityIds);
            }
            
            if (RefCouvSolPerenne.class.equals(klass)) {
                inputStream = exportService.exportCouvSolPerenne(entityIds);
            }
            
            if (RefActaTraitementsProduit.class.equals(klass)) {
                inputStream = exportService.exportActaTraitementsProducts(entityIds);
            }
            
            if (RefActaTraitementsProduitsCateg.class.equals(klass)) {
                inputStream = exportService.exportActaTraitementsProductsCateg(entityIds);
            }
            
            if (RefTraitSdC.class.equals(klass)) {
                inputStream = exportService.exportTraitSdC(entityIds);
            }
            
            if (RefZoneClimatiqueIphy.class.equals(klass)) {
                inputStream = exportService.exportZoneClimatiqueIphy(entityIds);
            }

            if (inputStream != null && log.isWarnEnabled()) {
                log.warn("Can't find valid export for class " + klass);
            }

        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't generate csv", ex);
            }
            throw new AgrosystTechnicalException("Can't create input stream", ex);
        }
        return inputStream;
    }

    public String getFilename() {
        String filename = "export" + StringUtils.substringAfterLast(genericClassName, ".") + ".csv";
        return filename;
    }
}
