package fr.inra.agrosyst.web.actions.admin;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AbstractAdminAction.java 3270 2014-02-17 11:08:03Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/actions/admin/AbstractAdminAction.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Preparable;

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.BufferStrip;
import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.FrostProtectionType;
import fr.inra.agrosyst.api.entities.GrowingSystemCharacteristicType;
import fr.inra.agrosyst.api.entities.HosesPositionning;
import fr.inra.agrosyst.api.entities.IrrigationSystemType;
import fr.inra.agrosyst.api.entities.MaxSlope;
import fr.inra.agrosyst.api.entities.OrchardFrutalForm;
import fr.inra.agrosyst.api.entities.PollinatorSpreadMode;
import fr.inra.agrosyst.api.entities.PompEngineType;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.SolWaterPh;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.VineFrutalForm;
import fr.inra.agrosyst.api.entities.WaterFlowDistance;
import fr.inra.agrosyst.api.entities.WeedType;
import fr.inra.agrosyst.api.entities.ZoneType;
import fr.inra.agrosyst.api.entities.Zoning;
import fr.inra.agrosyst.api.entities.action.CapacityUnit;
import fr.inra.agrosyst.api.entities.action.MineralProductUnit;
import fr.inra.agrosyst.api.entities.action.OrganicProductUnit;
import fr.inra.agrosyst.api.entities.action.PhytoProductUnit;
import fr.inra.agrosyst.api.entities.action.SeedPlantUnit;
import fr.inra.agrosyst.api.entities.action.SeedType;
import fr.inra.agrosyst.api.entities.action.YealdCategory;
import fr.inra.agrosyst.api.entities.action.YealdUnit;
import fr.inra.agrosyst.api.entities.managementmode.CategoryObjective;
import fr.inra.agrosyst.api.entities.managementmode.CategoryStrategy;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeCategory;
import fr.inra.agrosyst.api.entities.managementmode.SectionType;
import fr.inra.agrosyst.api.entities.managementmode.StrategyType;
import fr.inra.agrosyst.api.entities.measure.ChemicalElement;
import fr.inra.agrosyst.api.entities.measure.HorizonType;
import fr.inra.agrosyst.api.entities.measure.MeasureType;
import fr.inra.agrosyst.api.entities.measure.MeasurementType;
import fr.inra.agrosyst.api.entities.measure.NitrogenMolecule;
import fr.inra.agrosyst.api.entities.measure.ProductivityType;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemSource;
import fr.inra.agrosyst.api.entities.referential.*;
import fr.inra.agrosyst.api.services.generic.GenericEntityService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public abstract class AbstractAdminAction extends AbstractAgrosystAction implements Preparable {

    private static final long serialVersionUID = -5817371954801847984L;

    protected static final Class[] AUTHORITY_BASE_CLASSES = new Class[]{
            AgrosystInterventionType.class,
            BufferStrip.class,
            CapacityUnit.class,
            CategoryObjective.class,
            CategoryStrategy.class,
            ChemicalElement.class,
            CropCyclePhaseType.class,
            CroppingEntryType.class,
            DomainType.class,
            FrostProtectionType.class,
            HorizonType.class,
            HosesPositionning.class,
            IrrigationSystemType.class,
            ManagementModeCategory.class,
            MaxSlope.class,
            MeasurementType.class,
            MeasureType.class,
            NitrogenMolecule.class,
            OrchardFrutalForm.class,
            PollinatorSpreadMode.class,
            PompEngineType.class,
            PracticedSystemSource.class,
            ProductivityType.class,
            SectionType.class,
            Sector.class,
            SeedType.class,
            SolWaterPh.class,
            StrategyType.class,
            TypeDEPHY.class,
            SeedPlantUnit.class,
            VineFrutalForm.class,
            WaterFlowDistance.class,
            WeedType.class,
            YealdCategory.class,
            YealdUnit.class,
            Zoning.class,
            ZoneType.class,
            MineralProductUnit.class,
            GrowingSystemCharacteristicType.class,
            OrganicProductUnit.class,
            PhytoProductUnit.class
    };

    protected static final Class[] REFERENTIAL_BASE_CLASSES = new Class[]{
            RefActaTraitementsProduit.class,
            RefActaTraitementsProduitsCateg.class,
            RefFertiMinUNIFA.class,
            RefLocation.class,
            RefSolArvalis.class,
            RefLegalStatus.class,
            RefMaterielAutomoteur.class,
            RefMaterielIrrigation.class,
            RefMaterielTraction.class,
            RefMaterielOutil.class,
            RefEspece.class,
            RefVarieteGeves.class,
            RefVarietePlantGrape.class,
            RefClonePlantGrape.class,
            RefEspeceToVariete.class,
            RefOrientationEDI.class,
            RefOTEX.class,
            RefTypeTravailEDI.class,
            RefInterventionAgrosystTravailEDI.class,
            RefStadeEDI.class,
            RefParcelleZonageEDI.class,
            RefSolProfondeurIndigo.class,
            RefSolTextureGeppa.class,
            RefSolCaracteristiqueIndigo.class,
            RefStationMeteo.class,
            RefUniteEDI.class,
            RefAdventice.class,
            RefNuisibleEDI.class,
            RefFertiEngraisorg.class,
            RefFertiOrga.class,
            RefGesCarburant.class,
            RefGesEngrais.class,
            RefGesPhyto.class,
            RefGesSemence.class,
            RefNrjCarburant.class,
            RefNrjEngrais.class,
            RefNrjPhyto.class,
            RefNrjSemence.class,
            RefNrjGesOutil.class,
            RefMesure.class,
            RefSupportOrganeEDI.class,
            RefActaSubstanceActive.class,
            RefProtocoleVgObs.class,
            RefStadeNuisibleEDI.class,
            RefTypeNotationEDI.class,
            RefValeurQualitativeEDI.class,
            RefUnitesQualifiantEDI.class,
            RefElementVoisinage.class,
            RefPhytoSubstanceActiveIphy.class,
            RefTypeAgriculture.class, 
            RefActaGroupeCultures.class,
            RefActaDosageSPC.class,
            RefSaActaIphy.class,
            RefLienCulturesEdiActa.class,
            RefTraitSdC.class,
            RefCultureEdiGroupeCouvSol.class,
            RefCouvSolAnnuelle.class,
            RefCouvSolPerenne.class,
            RefZoneClimatiqueIphy.class
    };

    protected static final Function<Class, String> GET_CLASS_NAME = new Function<Class, String>() {
        @Override
        public String apply(Class input) {
            return input.getName();
        }
    };

    protected static List<String> authorityBaseClassNames;
    protected static List<String> referentialBaseClassNames;

    protected Map<String, Long> referentialClasses;

    protected Map<String, Long> authorityClasses;

    protected transient GenericEntityService service;

    public void setService(GenericEntityService service) {
        this.service = service;
    }

    protected void checkIsAdmin() {
        authorizationService.checkIsAdmin();
    }

    protected void sortFromI18n(Class<?>... classes) {
        Arrays.sort(classes, new Comparator<Class<?>>() {
            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                String className1 = o1.getName();
                String className2 = o2.getName();
                String text1 = getText(className1, className1);
                String text2 = getText(className2, className2);
                return text1.compareTo(text2);
            }
        });
    }

    protected static void resetReferentialBaseClassesList() {
        referentialBaseClassNames = Lists.newArrayList();
        Iterables.addAll(referentialBaseClassNames, Iterables.transform(Arrays.asList(REFERENTIAL_BASE_CLASSES), GET_CLASS_NAME));
    }

    protected static void resetAuthorityBaseClassesList() {
        authorityBaseClassNames = Lists.newArrayList();
        Iterables.addAll(authorityBaseClassNames, Iterables.transform(Arrays.asList(AUTHORITY_BASE_CLASSES), GET_CLASS_NAME));
    }

    @Override
    public void prepare() throws Exception {
        if (referentialBaseClassNames == null) {
            sortFromI18n(REFERENTIAL_BASE_CLASSES);
            resetReferentialBaseClassesList();
        }
        if (authorityBaseClassNames == null) {
            sortFromI18n(AUTHORITY_BASE_CLASSES);
            resetAuthorityBaseClassesList();
        }

        if (authorizationService.isAdmin()) {
            referentialClasses = service.countEntitiesFromString(referentialBaseClassNames);
            authorityClasses = service.countEntitiesFromString(authorityBaseClassNames);
        }

    }

    public Map<String, Long> getReferentialClasses() {
        return referentialClasses;
    }

    public Map<String, Long> getAuthorityClasses() {
        return authorityClasses;
    }

}
