package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebNotificationSupport.java 3463 2014-02-25 10:14:37Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebNotificationSupport.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.managementmode.DecisionRule;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeCategory;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.api.services.users.UserDto;

public class AgrosystWebNotificationSupport {

    protected AgrosystWebSession agrosystSession;

    public AgrosystWebNotificationSupport(AgrosystWebSession agrosystSession) {
        this.agrosystSession = agrosystSession;
    }

    public void domainSaved(Domain domain) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Domaine '%s' enregistré", domain.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void domainExtendError(String message) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(message);
        agrosystSession.getErrorNotifications().add(msg);
    }

    public void growingPlanSaved(GrowingPlan growingPlan) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Dispositif '%s' enregistré", growingPlan.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void growingSystemSaved(GrowingSystem growingSystem) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Système de culture '%s' enregistré", growingSystem.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void importError(String message, String error) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(message, error);
        agrosystSession.getErrorNotifications().add(msg);
    }

    public void importSuccess(String message, long duration, int created, int updated, int deleted, int ignored) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(message, duration, created, updated, deleted, ignored);
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void practicedSystemSaved(PracticedSystem practicedSystem) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Système synthétisé '%s' enregistré", practicedSystem.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void networkSaved(Network network) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Réseau '%s' enregistré", network.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void plotSaved(Plot plot) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Parcelle '%s' enregistrée", plot.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void plotUnactivated(Plot plot) {
        AgrosystWebNotification msg;
        if (plot.isActive()) {
            msg = AgrosystWebNotification.of("Parcelle '%s' activée", plot.getName());
        } else {
            msg = AgrosystWebNotification.of("Parcelle '%s' désactivée", plot.getName());
        }
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void plotDuplicated(Plot plot) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Parcelle '%s' dupliquée", plot.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void plotMerged(Plot plot) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Parcelles fusionnées en '%s'", plot.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void practicedPlotSaved(PracticedPlot practicedPlot) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Parcelle type '%s' enregistrée", practicedPlot.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void userSaved(UserDto user) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Utilisateur '%s %s' enregistré", user.getLastName(), user.getFirstName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void authenticatedUserSaved(UserDto user) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Profil enregistré");
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void decisionRuleSaved(DecisionRule decisionRule) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Règle de décision '%s' enregistrée", decisionRule.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void decisionRuleDuplicated(DecisionRule decisionRule) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Règle de décision '%s' dupliquée", decisionRule.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void managementModeDuplicated() {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Mode de gestion dupliquée");
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void newDecisionRuleCreated(DecisionRule newDecisionRule) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(
                "Version %d de la règle de décision '%s' créée",
                newDecisionRule.getVersionNumber(),
                newDecisionRule.getName());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void newManagementModeCreated(ManagementMode managementMode) {
        String txtMsg = managementMode.getCategory() == ManagementModeCategory.PLANNED ?
                "Mode de gestion prévu créé" : "Mode de gestion constaté créé";
        AgrosystWebNotification msg = AgrosystWebNotification.of(txtMsg);
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void managementModeSaved(ManagementMode managementMode) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Mode de gestion enregistré");
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void culturalInterventionCreated() {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Interventions culturales enregistrées");
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void performanceSaved(Performance performance) {
        AgrosystWebNotification msg = AgrosystWebNotification.of("Performance enregistrée. Le fichier est en cours de génération...");
        agrosystSession.getInfoNotifications().add(msg);
    }

    protected void notWritable(String entityType, String pronom) {
        String message = String.format("Vous n'avez pas les droits nécessaires pour modifier %s %s", pronom, entityType);
        AgrosystWebNotification msg = AgrosystWebNotification.of(message);
        agrosystSession.getWarningNotifications().add(msg);
    }

    protected void notWritable(String entityType) {
        notWritable(entityType, "ce");
    }

    public void domainNotWritable() {
        notWritable("domaine");
    }

    public void growingPlanNotWritable() {
        notWritable("dispositif");
    }

    public void growingSystemNotWritable() {
        notWritable("système de culture");
    }

    public void networkNotWritable() {
        notWritable("réseau");
    }

    public void practicedSystemNotWritable() {
        notWritable("système synthétisé");
    }

    public void managementModeNotWritable() {
        notWritable("mode de gestion");
    }

    public void decisionRuleNotWritable() {
        notWritable("règle de décision", "cette");
    }

    public void effectiveCropCyclesNotWritable() {
        notWritable("cycles réalisés", "ces");
    }

    public void performanceNotWritable() {
        notWritable("performance", "cette");
    }

    public void domainValidated(Domain domain) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(
                "Domaine '%s' validé pour la campagne '%d-%d'",
                domain.getName(),
                domain.getCampaign() - 1,
                domain.getCampaign());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void growingSystemValidated(GrowingSystem growingSystem) {
        int campaign = growingSystem.getGrowingPlan().getDomain().getCampaign();
        AgrosystWebNotification msg = AgrosystWebNotification.of(
                "Système de culture '%s' validé pour la campagne '%d-%d'",
                growingSystem.getName(),
                campaign - 1,
                campaign);
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void practicedSystemValidated(PracticedSystem practicedSystem) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(
                "Système synthétisé du système de culture '%s' validé pour les campagnes '%s'",
                practicedSystem.getGrowingSystem().getName(),
                practicedSystem.getCampaigns());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void growingPlanValidated(GrowingPlan growingPlan) {
        int campaign = growingPlan.getDomain().getCampaign();
        AgrosystWebNotification msg = AgrosystWebNotification.of(
                "Dispositif '%s' validé pour la campagne '%d-%d'",
                growingPlan.getName(),
                campaign - 1,
                campaign);
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void userImported(ImportResult result) {
        if(result.hasErrors()) {
            for (String error :result.getErrors()) {
                AgrosystWebNotification msg = AgrosystWebNotification.of(
                    error
                );
                agrosystSession.getInfoNotifications().add(msg);
            }
        } else {
            AgrosystWebNotification msg = AgrosystWebNotification.of(
                    "%d utilisateurs créés. %d email envoyés. %d lignes ignorées.",
                    result.getCreated(),
                    result.getCreated(),
                    result.getIgnored());
            agrosystSession.getInfoNotifications().add(msg);
        }
    }

    public void userRulesUpdated(ImportResult result) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(
                "%d rôles mis à jour.",
                result.getUpdated());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void networkImported(ImportResult result) {
        AgrosystWebNotification msg = AgrosystWebNotification.of(
                "%d réseaux mis à jour, %d réseaux crées.",
                result.getUpdated(),
                result.getCreated());
        agrosystSession.getInfoNotifications().add(msg);
    }

    public void plotNotMergeable() {
        AgrosystWebNotification msg = AgrosystWebNotification.of(
                "Les parcelles ne peuvent être fusionnées!"
        );
        agrosystSession.getInfoNotifications().add(msg);
    }
}
