package fr.inra.agrosyst.web;

/*
 * #%L
 * Agrosyst :: Web
 * $Id: AgrosystWebConfig.java 3114 2014-02-05 21:32:17Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-0.11/agrosyst-web/src/main/java/fr/inra/agrosyst/web/AgrosystWebConfig.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.config.ConfigOptionDef;

/**
 * Web module configuration.
 *
 * @author Eric Chatellier
 */
public class AgrosystWebConfig {

    /**
     * Configuration filename.
     */
    protected static final String AGROSYST_CONF_FILENAME = "agrosyst.properties";

    public static final String NAVIGATION_CONTEXT_COOKIE_NAME = "nav.context";

    /**
     * Delegate application config.
     */
    protected ApplicationConfig config;

    public AgrosystWebConfig() {
        config = new ApplicationConfig();
        config.loadDefaultOptions(WebConfigOption.values());
    }

    public void parse(String... args) {
        try {
            config.parse(args);
        } catch (ArgumentsParserException ex) {
            throw new RuntimeException("Can't read configuration", ex);
        }
    }

    public String getApplicationVersion() {
        return config.getOption(WebConfigOption.APPLICATION_VERSION.key);
    }

    public int getListResultsPerPage() {
        return config.getOptionAsInt(WebConfigOption.LIST_RESULTS_PER_PAGE.key);
    }

    public String getIgnKeyjs() {
        return config.getOption(WebConfigOption.IGN_KEYJS.key);
    }

    public long getUploadMaxSize() {
        return config.getOptionAsLong(WebConfigOption.UPLOAD_MAX_SIZE.key);
    }

    public String getUploadAllowedExtensions() {
        return config.getOption(WebConfigOption.UPLOAD_ALLOWED_EXTENSIONS.key);
    }

    public boolean isServicesRemoteEnabled() {
        return config.getOptionAsBoolean(WebConfigOption.SERVICES_REMOTE_ENABLED.getKey());
    }

    public String getServicesRemoteBaseUrl() {
        String result = config.getOption(WebConfigOption.SERVICES_REMOTE_BASE_URL.getKey());
        if (result != null && !result.endsWith("/")) {
            result += "/";
        }
        return result;
    }
    
    public String getContactEmail() {
        return config.getOption(WebConfigOption.CONTACT_EMAIL.getKey());
    }

    static enum WebConfigOption implements ConfigOptionDef {

        FILENAME(ApplicationConfig.CONFIG_FILE_NAME, AGROSYST_CONF_FILENAME),

        APPLICATION_VERSION("agrosyst.web.application.version", null),

        LIST_RESULTS_PER_PAGE("agrosyst.web.list.results.per.page", "10"),

        IGN_KEYJS("agrosyst.web.ign.keyjs", null),

        SERVICES_REMOTE_ENABLED("agrosyst.web.services.remote.enabled", "false"),

        SERVICES_REMOTE_BASE_URL("agrosyst.web.services.remote.baseUrl", null),

        CONTACT_EMAIL("agrosyst.web.email.contact", "agrosyst-devel@list.forge.codelutin.com"),

        /**
         * Upload config
         */
        UPLOAD_MAX_SIZE("agrosyst.web.upload.maxSize", "10240000"),

        UPLOAD_ALLOWED_EXTENSIONS("agrosyst.web.upload.allowedExtensions", "");

        private String key;
        private String defaultValue;

        private WebConfigOption(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getKey() {
            return key;
        }

        @Override
        public String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public Class<?> getType() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public void setDefaultValue(String defaultValue) {

        }

        @Override
        public void setTransient(boolean isTransient) {

        }

        @Override
        public void setFinal(boolean isFinal) {

        }
    }
}
