package fr.inra.agrosyst.services.pz0import.practicedSystem;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedSystemImportModel.java 5089 2015-09-09 07:44:14Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/PracticedSystemImportModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 16/12/14.
 */
class PracticedSystemImportModel extends AbstractAgrosystModelExtended<PracticedSystemImportDto> {


    PracticedSystemImportModel() {
        super();
        newMandatoryColumn("topiaid", PracticedSystemImportDto.PROPERTY_ID);
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", PracticedSystemImportDto.PROPERTY_NAME);
        newMandatoryColumn("campaigns", PracticedSystemImportDto.PROPERTY_CAMPAIGNS);
        newMandatoryColumn("comment", PracticedSystemImportDto.PROPERTY_COMMENT);
        newMandatoryColumn("active", PracticedSystemImportDto.PROPERTY_ACTIVE, O_N_PARSER);
        newMandatoryColumn("validated", PracticedSystemImportDto.PROPERTY_VALIDATED, O_N_PARSER);
        newMandatoryColumn("validationdate", PracticedSystemImportDto.PROPERTY_VALIDATION_DATE, DATE_PARSER);
        newMandatoryColumn("updatedate", PracticedSystemImportDto.PROPERTY_UPDATE_DATE, DATE_PARSER);
        newMandatoryColumn("source", PracticedSystemImportDto.PROPERTY_SOURCE_NAME);
        newMandatoryColumn("growingsystem", PracticedSystemImportDto.PROPERTY_GROWING_SYSTEM_ID);
    }

    @Override
    public PracticedSystemImportDto newEmptyInstance() {
        return new PracticedSystemImportDto();
    }
}
