package fr.inra.agrosyst.services.pz0import.effective.effectiveSpeciesStade;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: EffectiveSpeciesStadeImporter.java 5036 2015-07-10 21:45:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/effective/effectiveSpeciesStade/EffectiveSpeciesStadeImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStade;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDI;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDITopiaDao;
import fr.inra.agrosyst.api.services.itk.Itk;
import fr.inra.agrosyst.api.services.itk.SpeciesStadeDto;
import fr.inra.agrosyst.api.services.practiced.RefStadeEdiDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectiveIntervention;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.domain.dto.CroppingPlanSpeciesImportDto;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 13/04/15.
 */
public class EffectiveSpeciesStadeImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(EffectiveSpeciesStadeImporter.class);
    
    protected RefStadeEDITopiaDao refStadeEDIDao;

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(EffectiveSpeciesStade.class);
        log.debug("importfromstream");

        EffectiveSpeciesStadeImportModel model = new EffectiveSpeciesStadeImportModel();
        // récupère le DTO
        Import<EffectiveSpeciesStadeImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (EffectiveSpeciesStadeImportDto dto : importer) {
            boolean error;

            SpeciesStadeDto speciesStadeDto = new SpeciesStadeDto();

            // valid required related objets
            error = validEffectiveInterventionAffiliation(importResults, line, dto, speciesStadeDto, false);
            error = validCroppingPlanSpeciesAffiliation(importResults, line, dto, speciesStadeDto, error);

            // valid optional related objets
            error = validMinStade(importResults, line, dto, speciesStadeDto, error);
            error = validMaxStade(importResults, line, dto, speciesStadeDto, error);

            pz0IdToObject.put(SpeciesStadeDto.class, dto.getId(), speciesStadeDto);

            if (!error) {
                importResults.addInfoLine(line, ", " + "STADE DE CULTURE DU RÉALISÉ VALIDÉ, csvid: " + dto.getId());
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "STADE DE CULTURE DU RÉALISÉ IGNORÉ csvid:" + dto.getId());
            }
            line++;
        }
        return importResults;
    }

    protected boolean validEffectiveInterventionAffiliation(ImportResults importResults, long line, EffectiveSpeciesStadeImportDto from, SpeciesStadeDto speciesStadeDto, boolean error) {
        String effectiveInterventionId = from.getEffectiveInterventionId();
        if (StringUtils.isNotBlank(effectiveInterventionId)) {
            Pz0EffectiveIntervention interventionDto = (Pz0EffectiveIntervention) pz0IdToObject.get(Pz0EffectiveIntervention.class, effectiveInterventionId);
            if (interventionDto != null) {
                from.setPz0EffectiveIntervention(interventionDto);
                interventionDto.getEffectiveInterventionDto().addSpeciesStadesDto(speciesStadeDto);
            } else {
                error = true;
                importResults.addErrorLine(line, String.format("STADE DE CULTURE DU RÉALISÉ IGNORÉ!, l'intervention avec comme identifiant %s n'a pu etre retrouvée.", effectiveInterventionId));
            }
        } else {
            importResults.addErrorLine(line, "STADE DE CULTURE DU RÉALISÉ IGNORÉ!, la colonne 'effectiveintervention' n'est pas renseignée");
            error = true;
        }
        return error;
    }

    protected boolean validCroppingPlanSpeciesAffiliation(ImportResults importResults, long line, EffectiveSpeciesStadeImportDto from, SpeciesStadeDto to, boolean error) {
        String speciesId = from.getCroppingPlanSpeciesId();
        if (!error && StringUtils.isNotBlank(speciesId)) {
            Pz0EffectiveIntervention intervention = from.getPz0EffectiveIntervention();
            String cropId = intervention.getCropId();
            if (StringUtils.isNotBlank(cropId)) {
                CroppingPlanSpeciesImportDto speciesImportDto = (CroppingPlanSpeciesImportDto) pz0IdToObject.get(CroppingPlanSpeciesImportDto.class, speciesId);
                if (speciesImportDto.getCroppingPlanEntryId().contentEquals(cropId)) {
                    to.setSpeciesCode(speciesImportDto.getCode());
                } else {
                    error = true;
                    importResults.addErrorLine(line, String.format("STADE DE CULTURE DU RÉALISÉ IGNORÉ!, l'espèce %s n'a pu être retrouvée sur la culture %s.", speciesId, cropId));
                }
            } else {
                error = true;
                importResults.addErrorLine(line, "STADE DE CULTURE DU RÉALISÉ IGNORÉ!, aucune culture lié à l'intervention.");
            }
        }
        return error;
    }


    protected boolean validMinStade(ImportResults importResults, long line, EffectiveSpeciesStadeImportDto from, SpeciesStadeDto to, boolean error) {
        String minStadeId = from.getMinStadeId();

        if (StringUtils.isNotBlank(minStadeId)) {
            RefStadeEDI stadeEDI = refStadeEDIDao.forTopiaIdEquals(minStadeId).findUniqueOrNull();
            if (stadeEDI != null) {
                RefStadeEdiDto stadeEdiDto = Itk.STADE_EDI_TO_DTO.apply(stadeEDI);
                to.setStadeMin(stadeEdiDto);
            } else {
                error = true;
                importResults.addErrorLine(line, String.format("STADE DE CULTURE DU RÉALISÉ IGNORÉ!, le stade de culture d'on l'identifiant est %s n'a pu être retrouvé.", minStadeId));
            }
        }
        return error;
    }

    protected boolean validMaxStade(ImportResults importResults, long line, EffectiveSpeciesStadeImportDto from, SpeciesStadeDto to, boolean error) {
        String stadeId = from.getMinStadeId();

        if (StringUtils.isNotBlank(stadeId)) {
            RefStadeEDI stadeEDI = refStadeEDIDao.forTopiaIdEquals(stadeId).findUniqueOrNull();
            if (stadeEDI != null) {
                RefStadeEdiDto stadeEdiDto = Itk.STADE_EDI_TO_DTO.apply(stadeEDI);
                to.setStadeMax(stadeEdiDto);
            } else {
                error = true;
                importResults.addErrorLine(line, String.format("STADE DE CULTURE DU RÉALISÉ IGNORÉ!, le stade de culture d'on l'identifiant est %s n'a pu être retrouvé.", stadeId));
            }
        }
        return error;
    }

    @Override
    public void init(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        refStadeEDIDao = serviceContext.getPersistenceContext().getRefStadeEDIDao();
    }

}