package fr.inra.agrosyst.services.pz0import.effective.effectivePerennialCropCycle;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: EffectivePerennialCropCycleImportModel.java 5028 2015-07-10 06:33:13Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/effective/effectivePerennialCropCycle/EffectivePerennialCropCycleImportModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 01/04/15.
 */
class EffectivePerennialCropCycleImportModel extends AbstractAgrosystModelExtended<EffectivePerennialCropCycleImportDto> {

    EffectivePerennialCropCycleImportModel() {
        super();
        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("plantingyear", "plantingYear", INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("plantingdensity", "plantingDensity", DOUBLE_WITH_NULL_AND_9999_PARSER);

        newMandatoryColumn("plantinginterfurrow", "plantingInterFurrow", INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("plantingspacing", "plantingSpacing", INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("plantingdeathrate", "plantingDeathRate", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("plantingdeathratemeasureyear", "plantingDeathRateMeasureYear", INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("pollinator", "pollinator", T_F_PARSER);
        newMandatoryColumn("pollinatorpercent", "pollinatorPercent", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("othercharacteristics", "otherCharacteristics");
        newMandatoryColumn("orientation", "orientation");
        newMandatoryColumn("pollinatorspreadmode", "pollinatorSpreadMode");
        newMandatoryColumn("weedtype", "weedType");
        newMandatoryColumn("orchardfrutalform", "orchardFrutalForm");
        newMandatoryColumn("vinefrutalform", "vineFrutalForm");

        newMandatoryColumn("zone", "zoneId");
        newMandatoryColumn("croppingplanentry", "croppingPlanEntryId");
        newMandatoryColumn("phase", "phaseId");

        newMandatoryColumn("foliageheight","foliageHeight", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("foliagethickness", "foliageThickness", DOUBLE_WITH_NULL_AND_9999_PARSER);
    }

    @Override
    public EffectivePerennialCropCycleImportDto newEmptyInstance() {
        return new EffectivePerennialCropCycleImportDto();
    }
}
