package fr.inra.agrosyst.services.pz0import.effective.effectiveIntervention;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: EffectiveInterventionImportModel.java 5028 2015-07-10 06:33:13Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/effective/effectiveIntervention/EffectiveInterventionImportModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */


import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 05/02/15.
 */
class EffectiveInterventionImportModel extends AbstractAgrosystModelExtended<EffectiveInterventionImportDto> {

    EffectiveInterventionImportModel() {
        super();
        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", EffectiveIntervention.PROPERTY_NAME);
        newMandatoryColumn("comment", EffectiveIntervention.PROPERTY_COMMENT);
        newMandatoryColumn("startinterventiondate", "startInterventionDateSt");
        newMandatoryColumn("intermediatecrop", EffectiveIntervention.PROPERTY_INTERMEDIATE_CROP, T_F_PARSER);
        newMandatoryColumn("tillagedepth", EffectiveIntervention.PROPERTY_TILLAGE_DEPTH, INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("othertoolsettings", EffectiveIntervention.PROPERTY_OTHER_TOOL_SETTINGS);
        newMandatoryColumn("workrate", EffectiveIntervention.PROPERTY_WORK_RATE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("progressionspeed", EffectiveIntervention.PROPERTY_PROGRESSION_SPEED, INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("involvedpeoplecount", EffectiveIntervention.PROPERTY_INVOLVED_PEOPLE_COUNT, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("endinterventiondate", "endInterventionDateSt");
        newMandatoryColumn("spatialfrequency", EffectiveIntervention.PROPERTY_SPATIAL_FREQUENCY, DOUBLE_PARSER);
        newMandatoryColumn("transitcount", "transitCountInteger", INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("effectivecropcyclenode", "effectiveCropCycleNodeId");
        newMandatoryColumn("effectivecropcyclephase", "effectiveCropCyclePhaseId");
        newMandatoryColumn("type", "typeName");
        newOptionalColumn("transitvolumeunit", "transitVolumeUnitName");
        newOptionalColumn("workrateunit", "workRateUnitName");
    }

    @Override
    public EffectiveInterventionImportDto newEmptyInstance() {
        return new EffectiveInterventionImportDto();
    }
}
