package fr.inra.agrosyst.services.pz0import.effective.effectiveCropCycleNode;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: EffectiveCropCycleNodeImporter.java 5050 2015-08-03 14:48:03Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/effective/effectiveCropCycleNode/EffectiveCropCycleNodeImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleNodeDto;
import fr.inra.agrosyst.api.services.effective.EffectiveSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.api.services.pz0.effective.EffectiveCropCycleAndDependencies;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectiveCropCycleNode;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 02/04/15.
 */
public class EffectiveCropCycleNodeImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(EffectiveCropCycleNodeImporter.class);
    private static final String NEW_NODE = "new-node-";

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(EffectiveCropCycleNodeDto.class);
        log.debug("importfromstream");

        EffectiveCropCycleNodeImportModel model = new EffectiveCropCycleNodeImportModel();

        Import<EffectiveCropCycleNodeImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (EffectiveCropCycleNodeImportDto dto : importer) {
            boolean error;

            Pz0EffectiveCropCycleNode effectiveCropCycleNodeImport = new Pz0EffectiveCropCycleNode(dto.getId());
            EffectiveCropCycleNodeDto nodeDto = effectiveCropCycleNodeImport.getNode();

            // valid required related objects
            error = validCycleAffiliation(importResults, line, dto, effectiveCropCycleNodeImport, false);
            error = validCrops(importResults, line, dto, nodeDto, error);

            // valid required attribute
            error = validRank(importResults, line, dto, effectiveCropCycleNodeImport, error);

            nodeDto.setNodeId(NEW_NODE + dto.getId());

            // need to be able to find it out effectiveCropCycleNodeDto to add phase ont it
            pz0IdToObject.put(Pz0EffectiveCropCycleNode.class, dto.getId(), effectiveCropCycleNodeImport);

            if (!error) {
                importResults.addInfoLine(line, ", " + "NOEUD DU RÉALISÉ VALIDÉ, csvid: " + dto.getId());
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "NOEUD DU RÉALISÉ IGNORÉ csvid:" + dto.getId());
            }

            line++;
        }
        return importResults;
    }

    protected boolean validCycleAffiliation(ImportResults importResults, long line, EffectiveCropCycleNodeImportDto from, Pz0EffectiveCropCycleNode to, boolean error) {
        String cropCycleId = from.getEffectiveSeasonalCropCycleId();
        if (StringUtils.isNotBlank(cropCycleId)) {
            EffectiveCropCycleAndDependencies cycleAndDependencies = getCycleAndDependencies(from);
            if (cycleAndDependencies == null || cycleAndDependencies.getEffectiveSeasonalCropCycleDto(cropCycleId) == null) {
                importResults.addErrorLine(line, String.format("NOEUD DU RÉALISÉ IGNORÉ!, aucun cycle n'est retrouvé avec l'identifiant suivant: %s", cropCycleId));
                error = true;
            } else {
                to.setEffectiveSeasonalCropCycleId(cropCycleId);
            }
        } else {
            importResults.addErrorLine(line, "NOEUD DU RÉALISÉ IGNORÉ!, la colonne 'effectiveseasonalcropcycle' n'est pas renseignée");
            error = true;
        }
        return error;
    }


    protected boolean validCrops(ImportResults importResults, long line, EffectiveCropCycleNodeImportDto dto, EffectiveCropCycleNodeDto effectiveCropCycleNodeDto, boolean error) {
        String cropId = dto.getCroppingPlanEntryId();
        if (StringUtils.isNotBlank(cropId) && !error) {
            try {
                // find cycle to get zone to get domain's crop
                EffectiveCropCycleAndDependencies cycleAndDependencies = getCycleAndDependencies(dto);
                DomainAndDependencies domainAndDependencies = cycleAndDependencies.getDomainAndDependencies();
                if (domainAndDependencies != null) {
                    Map<String, CroppingPlanEntryDto> cropIds = domainAndDependencies.getCroppingPlanEntryDtosByPZ0CsvId();
                    if (cropIds != null && !cropIds.isEmpty()) {
                        CroppingPlanEntryDto crop = cropIds.get(cropId);
                        if (crop != null){
                            if (!crop.isIntermediate()) {
                                effectiveCropCycleNodeDto.setCroppingPlanEntryId(cropId);
                            } else {
                                error = true;
                                importResults.addErrorLine(line, String.format("NOEUD DU RÉALISÉ IGNORÉ!, la culture avec comme identifiant: '%s' est une culture intermédiaire", cropId));
                            }
                        } else {
                            error = true;
                            importResults.addErrorLine(line, String.format("NOEUD DU RÉALISÉ IGNORÉ!, la culture avec comme identifiant: '%s' n'a pas été retrouvée", cropId));
                        }
                    } else {
                        error = true;
                        importResults.addErrorLine(line, String.format("NOEUD DU RÉALISÉ IGNORÉ!, la culture avec comme identifiant: '%s' n'a pas été retrouvée sur le domaine %s", cropId, domainAndDependencies.getCsvId()));
                    }
                } else {
                    error = true;
                    importResults.addErrorLine(line, String.format("NOEUD DU RÉALISÉ IGNORÉ!, la zone '%s' n'est attachée à aucun domaine", cycleAndDependencies.getZoneId()));
                }


            } catch (NullPointerException e) {
                error = true;
                importResults.addErrorLine(line, String.format("NOEUD DU RÉALISÉ IGNORÉ!, la culture avec comme identifiant:%s n'a pas été retrouvée", cropId));
            }

        } else {
            error = true;
            importResults.addErrorLine(line, "NOEUD DU RÉALISÉ IGNORÉ!, la colone 'croppingplanentry' n'est pas renseignée");
        }
        return  error;
    }

    protected boolean validRank(ImportResults importResults, long line, EffectiveCropCycleNodeImportDto dto, Pz0EffectiveCropCycleNode pz0Node, boolean error) {
        Integer rank = dto.getRank();
        if (rank != null) {
            pz0Node.getNode().setRank(rank);
            EffectiveCropCycleAndDependencies cycleAndDependencies = getCycleAndDependencies(dto);
            if (cycleAndDependencies != null) {
                Pz0EffectiveSeasonalCropCycle cycle = cycleAndDependencies.getEffectiveSeasonalCropCycleDto(dto.getEffectiveSeasonalCropCycleId());
                EffectiveCropCycleNodeDto sameRankNode = cycle.getNodeAtRank(rank);
                if (sameRankNode != null) {
                    error = true;
                    importResults.addErrorLine(line, String.format("NOEUD DU RÉALISÉ IGNORÉ!, le noeud %s existe déjà sur le rang %d", pz0Node.getCsvId(), rank));
                } else {
                    cycle.addPz0NodeDto(pz0Node);
                }
            }

        } else {
            error = true;
            importResults.addErrorLine(line, "NOEUD DU RÉALISÉ IGNORÉ!, la colone 'rank' n'est pas renseignée");
        }
        return error;
    }

    protected EffectiveCropCycleAndDependencies getCycleAndDependencies(EffectiveCropCycleNodeImportDto dto) {
        EffectiveCropCycleAndDependencies cycleAndDependencies = null;
        if (StringUtils.isNotBlank(dto.getEffectiveSeasonalCropCycleId())) {
            cycleAndDependencies = (EffectiveCropCycleAndDependencies) pz0IdToObject.get(EffectiveSeasonalCropCycleDto.class, EffectiveCropCycleAndDependencies.class, dto.getEffectiveSeasonalCropCycleId());
        }
        return cycleAndDependencies;
    }
}
