package fr.inra.agrosyst.services.pz0import.domain.model;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: CroppingPlanEntryImportModel.java 5028 2015-07-10 06:33:13Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/model/CroppingPlanEntryImportModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;
import fr.inra.agrosyst.services.pz0import.domain.dto.CroppingPlanEntryImportDto;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by davidcosse on 05/12/14.
 */
public class CroppingPlanEntryImportModel extends AbstractAgrosystModelExtended<CroppingPlanEntryImportDto> {

    private static final Log log = LogFactory.getLog(CroppingPlanEntryImportModel.class);

    public CroppingPlanEntryImportModel() {
        super();

        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newMandatoryColumn("code", "code");
        newMandatoryColumn("domain", "domainId");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", "name");
        newMandatoryColumn("sellingprice", "sellingPrice", DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("validated", "validated", T_F_PARSER);
        newMandatoryColumn("type", "typeImporterValue");
    }

    @Override
    public CroppingPlanEntryImportDto newEmptyInstance() {
        return new CroppingPlanEntryImportDto();
    }

}
