package fr.inra.agrosyst.services.pz0import.action.seedingActionSpecies;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: SeedingActionSpeciesImporter.java 5096 2015-10-09 09:45:52Z eancelet $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/action/seedingActionSpecies/SeedingActionSpeciesImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.OtherActionImpl;
import fr.inra.agrosyst.api.entities.action.SeedPlantUnit;
import fr.inra.agrosyst.api.entities.action.SeedingAction;
import fr.inra.agrosyst.api.entities.action.SeedingActionImpl;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpecies;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpeciesImpl;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleSpeciesDto;
import fr.inra.agrosyst.api.services.itk.SpeciesStadeDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectiveCropCyclePhase;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectiveIntervention;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedCropCyclePhase;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedIntervention;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedPerennialCropCycle;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by davidcosse on 12/02/15.
 */
public class SeedingActionSpeciesImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(SeedingActionSpeciesImporter.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(SeedingActionSpecies.class);

        SeedingActionSpeciesModel model = new SeedingActionSpeciesModel();
        // récupère le DTO
        Import<SeedingActionSpeciesImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (SeedingActionSpeciesImportDto dto : importer) {
            boolean error;

            // valid required fields
            error = validSeedingSpeciesAction(importResults, line, dto, false);

            error = validSeedingActionSpecies(importResults, line, dto, error);

            error = validSeedPlanUnit(importResults, line, dto, error);

            if (!error) {
                setQuantity(dto);
                SeedingActionSpecies seedingActionSpecies = new SeedingActionSpeciesImpl();
                Binder<SeedingActionSpeciesImportDto, SeedingActionSpecies> binder = BinderFactory.newBinder(SeedingActionSpeciesImportDto.class, SeedingActionSpecies.class);
                binder.copy(dto, seedingActionSpecies);
                SeedingAction seedingAction = dto.getSeedingAction();
                seedingAction.addSeedingSpecies(seedingActionSpecies);

                importResults.addInfoLine(line, ", " + "AJOUT D'UNE ESPÈCE POUR L'ACTION DE TYPE SEMIS VALIDÉ");
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "AJOUT D'UNE ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉ");
            }
            line++;
        }
        return importResults;
    }

    protected boolean validSeedingSpeciesAction(ImportResults importResults, long line, SeedingActionSpeciesImportDto from, boolean error) {

        if (StringUtils.isNotBlank(from.getSeedingActionId())) {
            if ( ! pz0IdToObject.get(AbstractAction.class, from.getSeedingActionId()).getClass().equals(SeedingActionImpl.class)) {
                error = true;
                importResults.addErrorLine(line, String.format("AJOUT DE L'ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉ!, l'action %s à laquelle elle est reliée la seedingactionspecies n'est pas de type de semis, elle est de type %s.", from.getSeedingActionId(), pz0IdToObject.get(AbstractAction.class, from.getSeedingActionId()).getClass()));
            } else {
                SeedingAction seedingAction = (SeedingAction)pz0IdToObject.get(AbstractAction.class, from.getSeedingActionId());
                if (seedingAction == null) {
                    error = true;
                    importResults.addErrorLine(line, String.format("AJOUT DE L'ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉ!, l'action de semis avec l'identifiant '%s' n'a pas été retrouvée.", from.getSeedingActionId()));
                } else {
                    from.setSeedingAction(seedingAction);
                }
            }
        } else {
            error = true;
            importResults.addErrorLine(line, "AJOUT DE L'ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉ!, La colonne 'seedingaction' doit être renseignée.");
        }

        return error;
    }

    protected boolean validSeedingActionSpecies(ImportResults importResults, long line, SeedingActionSpeciesImportDto from, boolean error) {
        String seedingActionSpeciesCode = from.getSpeciesCode();
        if (StringUtils.isNotBlank(seedingActionSpeciesCode)) {
            Pair<String, Set<String>> speciesCodesForInterventionId = getSpeciesCodesFromSeedingAction(from);
            Set<String> speciesCodes = speciesCodesForInterventionId.getRight();

            if (CollectionUtils.isNotEmpty(speciesCodes)) {
                final String agrosystCode = csvCodeToAgrosystCode(CroppingPlanEntryDto.class, seedingActionSpeciesCode);
                if (speciesCodes.contains(agrosystCode)) {
                    from.setSpeciesCode(agrosystCode);
                    SeedingAction seedingAction = from.getSeedingAction();
                    if (seedingAction != null) {
                        Collection<SeedingActionSpecies> seedingActionSpecies = seedingAction.getSeedingSpecies();
                        if (CollectionUtils.isNotEmpty(seedingActionSpecies)) {
                            try {
                                Map<String, SeedingActionSpecies> seedingActionSpeciesBySpeciesCode = Maps.uniqueIndex(seedingActionSpecies, getSeedingActionSpeciesAgrosystSpeciesCode());
                                if (seedingActionSpeciesBySpeciesCode.containsKey(agrosystCode)) {
                                    error = true;
                                    importResults.addErrorLine(line, String.format("AJOUT DE L'ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉE!, l'espèce au code '%s' est déjà affectée à l'action '%s'.", seedingActionSpeciesCode, seedingAction));
                                }
                            } catch (Exception e) {
                                error = true;
                                importResults.addErrorLine(line, String.format("AJOUT DE L'ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉE!, plusieurs SeedingActionSpecies avec un code identique pointent vers l'action au code '%s'.", seedingActionSpeciesCode));
                            }
                        }
                    }
                } else {
                    error = true;
                    String allowedSpeciesCodes = "";
                    for (String agrosystSpeciesCode : speciesCodes) {
                        String csvSpeciesCode = agrosystCodeToPz0Code.get(CroppingPlanEntryDto.class, agrosystSpeciesCode);
                        allowedSpeciesCodes += " "+ csvSpeciesCode;
                    }
                    importResults.addErrorLine(line, String.format("AJOUT DE L'ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉE!, l'espèce dont le code est '%s' n'a pas été retrouvée à partir de l'intervention dont l'identifiant est '%s'. Les speciesCode possibles sont [%s]", seedingActionSpeciesCode, speciesCodesForInterventionId.getLeft(), allowedSpeciesCodes));
                }
            } else {
                error = true;
                importResults.addErrorLine(line, String.format("AJOUT DE L'ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉE!, aucune espèce n'a pu être retrouvée sur l'intervention '%s'.", speciesCodesForInterventionId.getLeft()));
            }
        } else {
            error = true;
            importResults.addErrorLine(line, String.format("AJOUT DE L'ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉE!, le speciescode n'est pas renseigné pour l'enregistrement de topiaId : %s.", from.getId()));
        }
        return error;
    }

    public static Function<SeedingActionSpecies, String> getSeedingActionSpeciesAgrosystSpeciesCode() {
        return new Function<SeedingActionSpecies, String>() {
            @Override
            public String apply(SeedingActionSpecies input) {
                String agrosystSpeciesCode = input.getSpeciesCode();
                return agrosystSpeciesCode;
            }
        };
    }

    
    protected Pair<String, Set<String>> getSpeciesCodesFromSeedingAction(SeedingActionSpeciesImportDto from) {
        Set<String> speciesCodes = null;
        String interventionId = " INTERVENTION NON RETROUVÉE";

        Pz0PracticedIntervention pz0PracticedIntervention = (Pz0PracticedIntervention) pz0IdToObject.get(AbstractAction.class, Pz0PracticedIntervention.class, from.getSeedingActionId());
        if (pz0PracticedIntervention != null) {
            interventionId = pz0PracticedIntervention.getCsvId();            
            if (!StringUtils.isEmpty(pz0PracticedIntervention.getPracticedConnectionId())) { // if the intervention is linked to a seasonal cycle                
                List<SpeciesStadeDto> speciesStadeDtos = pz0PracticedIntervention.getPracticedInterventionDto().getSpeciesStadesDtos();
                speciesCodes = getSpeciesStadeCodes(speciesStadeDtos);
            } else { // if the intervention is linked to a perennial cycle
                String myPhaseId = pz0PracticedIntervention.getPracticedPhaseId();
                Pz0PracticedCropCyclePhase pz0PracticedPhase = (Pz0PracticedCropCyclePhase) pz0IdToObject.get(Pz0PracticedCropCyclePhase.class, myPhaseId);
                String perennialCyclePz0Id = pz0PracticedPhase.getPracticedPerennialCropCycleId();
                Pz0PracticedPerennialCropCycle pz0PerennialCycle = (Pz0PracticedPerennialCropCycle) pz0IdToObject.get(Pz0PracticedPerennialCropCycle.class, perennialCyclePz0Id);
                List<String> speciesPz0Codes = pz0PerennialCycle.getPracticedPerennialCropCycleDto().getCroppingPlanSpeciesIds();
                if (speciesPz0Codes != null) {
                    speciesCodes = new HashSet<String>();
                    for (String speciesPz0Code : speciesPz0Codes) {
                        String speciesAgrosystCode = csvCodeToAgrosystCode(CroppingPlanEntryDto.class, speciesPz0Code);
                        speciesCodes.add(speciesAgrosystCode);
                    }
                }

            }
        } else { // if intervention is effective
            Pz0EffectiveIntervention pz0EffectiveIntervention = (Pz0EffectiveIntervention) pz0IdToObject.get(AbstractAction.class, Pz0EffectiveIntervention.class, from.getSeedingActionId());
            if (pz0EffectiveIntervention != null) {
                interventionId = pz0EffectiveIntervention.getCsvId();
                if (pz0EffectiveIntervention.getPz0NodeId() != null) { // if the intervention is linked to a seasonal cycle
                    List<SpeciesStadeDto> speciesStadeDtos = pz0EffectiveIntervention.getEffectiveInterventionDto().getSpeciesStadesDtos();
                    speciesCodes = getSpeciesStadeCodes(speciesStadeDtos);
                } else { // if the intervention is linked to a perennial cycle
                    Pz0EffectiveCropCyclePhase phaseDto = (Pz0EffectiveCropCyclePhase) pz0IdToObject.get(Pz0EffectiveCropCyclePhase.class, pz0EffectiveIntervention.getPz0PhaseId());
                    if (phaseDto != null && StringUtils.isNotBlank(phaseDto.getPerennialCropCycleId())) {
                        Pz0EffectivePerennialCropCycle cycle = (Pz0EffectivePerennialCropCycle)pz0IdToObject.get(Pz0EffectivePerennialCropCycle.class, phaseDto.getPerennialCropCycleId());
                        if (cycle != null && cycle.getPerennialCropCycleDto() != null) {
                            Collection<EffectiveCropCycleSpeciesDto> speciesDtos = cycle.getPerennialCropCycleDto().getSpeciesDtos();
                            if (speciesDtos != null) {
                                speciesCodes = new HashSet<String>();
                                for (EffectiveCropCycleSpeciesDto speciesDto : speciesDtos) {
                                    speciesCodes.add(speciesDto.getCode());
                                }
                            }
                        }
                    }
                }
            }
        }
        Pair<String, Set<String>> result = Pair.of(interventionId, speciesCodes);
        return result;
    }
   


    protected boolean validSeedPlanUnit(ImportResults importResults, long line, SeedingActionSpeciesImportDto from, boolean error) {

        if (StringUtils.isNotBlank(from.getSeedPlantUnitName())) {
            try{
                SeedPlantUnit seedPlantUnit = SeedPlantUnit.valueOf(from.getSeedPlantUnitName());
                from.setSeedPlantUnit(seedPlantUnit);
            } catch (IllegalArgumentException e) {
                error = true;
                importResults.addErrorLine(line, String.format("AJOUT DE L'ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉ!, unité de semis incorrect %s.", from.getSeedPlantUnitName()));
            }
        }

        return error;
    }

    protected void setQuantity(SeedingActionSpeciesImportDto from) {

        if (from.getQuantityWithNull() != null) {
            from.setQuantity(from.getQuantityWithNull());
        } else {
            from.setQuantity(0);
        }
    }

}
